// proport_dac.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

extern "C" {
#include "s56dspUser.h"
#include "qckMon.h"
#include "drp.h"
}

#undef debug

#include "application.h"
#include "proport_dac.h"
#include "statusaction.h"

ProportConverter::ProportConverter() : drp(nil) {
	failIf(!initialize());
}

ProportConverter::~ProportConverter() {
	close();
}

boolean
ProportConverter::isPlayableFormat(DataType type) {
	return type == ShortData;
}

void
ProportConverter::close() {
	BUG("ProportConverter::close()");
	if(drp && drp->dsp)
		(void) ::close(drp->dsp->fd);
}

void
ProportConverter::fail() {
	BUG("ProportConverter::fail()");
	if(running()) stop();
	Super::fail();
}

boolean
ProportConverter::initialize() {
	// DSP application program
	static char	dspcode[256] = "/usr/local/s56dsp/libdrp/ssirp.lod";
	const int	nbits = 16;				// DMA mode (number of bits)
	const int	pagesize = 128*1024;	// DMA page size
	const int	writesize = 16384;
	boolean status = true;
	if((drp = drp_bootdsp("qckMon.lod", dspcode)) == NULL) {
		error("drp_bootdsp failed");
		status = false;
	}
	else if(drp->error[0]) {
		Application::alert("drp_bootdsp failed:", drp->error);
		status = false;
	}
	else if(drp_confio(drp, nbits, pagesize, writesize) == -1) {
		Application::alert("drp_confio failed:", drp->error);
		status = false;
	}
	return status;
}

int
ProportConverter::checkSampleRate(int rate) {
	static char periph[256] = "proport";	// Peripheral
	if(drp_confperiph(drp, periph, rate,
			willRecord() ? DRP_DIR_TODISK : DRP_DIR_TODSP) == -1) {
		char msg[256];
		sprintf(msg,
			"Cannot set sample rate to %d.  drp_confperiph: %s",
			rate, drp->error);
		Application::alert(msg);
		return false;
	}
	return true;
}

int
ProportConverter::checkChannels(int chans) {
	if(chans != 2) {
		Application::alert(
			"This converter can only play and record stereo sound."
		);
		return false;
	}
	return true;
}

int
ProportConverter::doConfigure() {
	BUG("ProportConverter::configure()");
	boolean status = true;
	if(drp_start(drp, willRecord()? DRP_DIR_TODISK:DRP_DIR_TODSP) == -1) {
		Application::alert(
			"ProportConverter::configure: drp_start failed:",
			drp->error);
		status = false;
	}
	return status;
}

int
ProportConverter::doConversion(StatusAction* askedToStop) {
	int bytesToGo = dataSize();
	int bufsize = min(dataSize(), bufferSize());
	addr databuffer = (addr) pointerToData();

	Application::inform("Playing...");
#ifdef DEBUG_PROPORT
	fprintf(stderr, "starting conversion.  total bytes = %d\n\n",bytesToGo);
#endif
	while(bytesToGo > 0) {
		if((*askedToStop)())
			return stop();
		int bytesWritten = ::write(drp->dsp->fd, databuffer, bufsize);
		if(bytesWritten < 0) {
			error("ProportConverter::doConversion:  write error");
			return false;
		}
		else if(bytesWritten != bufsize) {
			char msg[256];
			sprintf(msg, "write error: %d != %d", bytesWritten, bufsize);
			error(msg);
			return false;
		}
		bytesToGo -= bufsize;
#ifdef DEBUG_PROPORT
		fprintf(stderr, "%d byte block written.  %d bytes left.\n", bytesWritten, bytesToGo);
#endif
		databuffer += bufsize;
		bufsize = min(bufsize, bytesToGo);
	}
	return stop();
}

int
ProportConverter::doRecording(StatusAction* askedToStop) {
	int bytesToGo = dataSize();
	int bufsize = min(dataSize(), bufferSize());
	addr databuffer = (addr) pointerToData();

	Application::inform("Recording...");
	while(bytesToGo > 0) {
		if((*askedToStop)())
			return stop();
		int bytesRead = ::read(drp->dsp->fd, databuffer, bufsize);
		if(bytesRead < 0) {
			error("ProportConverter::doRecording: read error");
			return false;
		}
		else if(bytesRead != bufsize) {
			char msg[256];
			sprintf(msg, "read error: %d != %d", bytesRead, bufsize);
			error(msg);
			return false;
		}
		else if(bytesRead == 0) {
			Application::alert("read: got EOF from DSP.");
			stop();
			return false;
		}
		bytesToGo -= bufsize;
		databuffer += bufsize;
		bufsize = min(bufsize, bytesToGo);
	}
	return stop();
}

int
ProportConverter::stop() {
	BUG("ProportConverter::stop()");
	if (drp_end(drp) == -1) {
		Application::alert(
			"ProportConverter::stop: drp_end failed:", drp->error);
		return false;
	}
	// else
	return Super::stop();
}
