;; $Id: dblists.dsl 1.0 1997/12/30 17:48:14 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; =============================== LISTS ================================

(element ORDEREDLIST
  (let* ((depth (length (hierarchical-number-recursive "ORDEREDLIST")))
	 (rawnum (case (attribute-string "NUMERATION")
		   (("ARABIC") 0)
		   (("LOWERALPHA") 1)
		   (("LOWERROMAN") 2)
		   (("UPPERALPHA") 3)
		   (("UPPERROMAN") 4)
		   (else (modulo depth 5))))
	 (type (case rawnum
		 ((0) "1")
		 ((1) "a")
		 ((2) "i")
		 ((3) "A")
		 ((4) "I"))))
    (make sequence
      (if %spacing-paras%
	  (make element gi: "P" (empty-sosofo))
	  (empty-sosofo))
      (make element gi: "OL"
	    attributes: (if (equal? (attribute-string "SPACING") "COMPACT")
			    (list
			     (list "COMPACT" "COMPACT")
			     (list "TYPE" type))
			    (list
			     (list "TYPE" type)))
	    (process-children)))))
    
(element ITEMIZEDLIST
  (make sequence
    (if %spacing-paras%
	(make element gi: "P" (empty-sosofo))
	(empty-sosofo))
    (make element gi: "UL"
	  attributes: (if (equal? (attribute-string "SPACING") "COMPACT")
			  '(("COMPACT" "COMPACT"))
			  '())
	  (process-children))))

(element LISTITEM
  (make element gi: "LI"
	(process-children)))

(element VARIABLELIST
  (make sequence
    (if %spacing-paras%
	(make element gi: "P" (empty-sosofo))
	(empty-sosofo))
    (make element gi: "DL"
	  (process-children))))

(element VARLISTENTRY
  (make element gi: "DT"
	(if (attribute-string "ID")
	    (make element gi: "A"
		  attributes: (list
			       (list "NAME" (attribute-string "ID")))
		  (process-children))
	    (process-children))))

(element (VARLISTENTRY TERM)
  (make sequence
    (process-children-trim)
    (if (not (last-sibling?))
	(literal ", ")
	(literal ""))))

(element (VARLISTENTRY LISTITEM)
  (make element gi: "DD"
	(process-children)))

(define (simplelist-table majororder cols members)
  (let* ((termcount (node-list-length members))
	 (rows (quotient (+ termcount (- cols 1)) cols)))
    (make sequence
      (if %spacing-paras%
	  (make element gi: "P" (empty-sosofo))
	  (empty-sosofo))
      (make element gi: "TABLE"
	    attributes: '(("BORDER" "0"))
	    (let rowloop ((rownum 1))
	      (if (> rownum rows)
		  (empty-sosofo)
		  (make sequence
		    (simplelist-row rownum majororder rows cols members)
		    (rowloop (+ rownum 1)))))))))

(define (simplelist-row rownum majororder rows cols members)
  (make element gi: "TR"
	(let colloop ((colnum 1))
	  (if (> colnum cols)
	      (empty-sosofo)
	      (make sequence
		(simplelist-entry rownum colnum majororder rows cols members)
		(colloop (+ colnum 1)))))))

(define (simplelist-entry rownum colnum majororder rows cols members)
  (let ((membernum (if (equal? majororder 'row)
		       (+ (* (- rownum 1) cols) colnum)
		       (+ (* (- colnum 1) rows) rownum)))
	(attlist   (if %simplelist-column-width%
		       (list (list "WIDTH" %simplelist-column-width%))
		       '())))
    (let loop ((nl members) (count membernum))
      (if (<= count 1)
	  (make element gi: "TD"
		attributes: attlist
		(if (node-list-empty? nl)
		    (make entity-ref name: "nbsp")
		    (process-node-list (node-list-first nl))))
	  (loop (node-list-rest nl) (- count 1))))))

(element SIMPLELIST
  (let ((type (attribute-string "type"))
	(cols (if (attribute-string "columns")
		  (if (> (string->number (attribute-string "columns")) 0)
		      (string->number (attribute-string "columns"))
		      1)
		  1))
	(members (select-elements (children (current-node)) "MEMBER")))
    (case type
       (("INLINE") (process-children))
       (("VERT")   (simplelist-table 'column cols members))
       (("HORIZ")  (simplelist-table 'row    cols members)))))

(element MEMBER
  (let ((type (inherited-attribute-string "type")))
    (if (equal? type "INLINE")
	(make sequence
	  (process-children-trim)
	  (if (not (last-sibling?))
	      (literal ", ")
	      (literal "")))
	(process-children))))

(element SEGMENTEDLIST (process-children))
(element (SEGMENTEDLIST TITLE) ($lowtitle$ 6))

(element SEGTITLE (empty-sosofo))

(mode seglist-in-seg
  (element SEGTITLE
    (make element gi: "B"
	  (process-children))))

(element SEGLISTITEM ($paragraph$))
(element SEG 
  (let* ((seg-num (child-number (current-node)))
	 (seglist (parent (parent (current-node))))
	 (segtitle (nth-node (select-elements 
			 (descendants seglist) "SEGTITLE") seg-num)))

    ;; Note: segtitle is only going to be the right thing in a well formed
    ;; SegmentedList.  If there are too many Segs or too few SegTitles,
    ;; you'll get something odd...maybe an error

    (with-mode seglist-in-seg
      (make element gi: "P"
	    (make element gi: "B"
		  (sosofo-append (process-node-list segtitle))
		  (literal ": "))
	    (process-children)))))

(element CALLOUTLIST 
  (let* ((nsep  (gentext-label-title-sep (gi)))
	 (id    (attribute-string "ID"))
	 (titlesosofo (make sequence
			(literal (gentext-element-name (gi)))
			(if (string=? (element-label) "")
			    (literal nsep)
			    (literal " " (element-label) nsep))
			(element-title-sosofo))))
    (make element gi: "DIV"
	  attributes: (list
		       (list "CLASS" (gi)))
	  (if (node-list-empty? 
	       (select-elements (children (current-node)) "TITLE"))
	      (empty-sosofo)
	      (make element gi: "P"
		    (make element gi: "B"
			  (if id
			      (make element gi: "A"
				    attributes: (list (list "NAME" id))
				    titlesosofo)
			      titlesosofo))))
	  (make element gi: "DL"
		attributes: '(("COMPACT" "COMPACT"))
		(process-children)))))

(element (CALLOUTLIST TITLE) (empty-sosofo))

(element CALLOUT 
  (process-children))

(element (CALLOUTLIST CALLOUT)
  (process-children))

(element (CALLOUTLIST CALLOUT PARA)
  (make sequence
    (if (= (child-number) 1)
	(let* ((ilevel (length (hierarchical-number-recursive "CALLOUTLIST")))
	       (arearefs (inherited-attribute-string "AREAREFS"))
	       (idlist (split arearefs)))
	  (make sequence
	    (make element gi: "DT"
		  (let loop ((ids idlist))
		    (if (null? ids)
			(empty-sosofo)
			(make sequence
			  ($callout-mark$ (element-with-id (car ids)) #f)
			  (loop (cdr ids))))))
	    (make element gi: "DD"
		  (process-children))))
	(make element gi: "DD"
	      (make element gi: "P"
		    (process-children))))))

