;; $Id: dbcompon.dsl 1.4 1998/02/19 17:59:12 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ============================= COMPONENTS =============================
;;
;; in docbook, components are containers at the chapter/appendix level

(define ($title-header-footer-element$)
  (let* ((firstchild (node-list-first (children (current-node))))
	 (metainfo   (if (node-list-empty? firstchild)
			 (empty-node-list)
			 (if (member (gi firstchild)
				     '("DOCINFO" "ARTHEADER"))
			     firstchild
			     (empty-node-list))))
	 (metatitle  (select-elements (children metainfo) "TITLE"))
	 (metatabb   (select-elements (children metainfo) "TITLEABBREV"))
	 (title      (select-elements (children (current-node)) 
				      "TITLE"))
	 (titleabb   (select-elements (children (current-node)) 
				      "TITLEABBREV")))
    (if (node-list-empty? metatabb)
	(if (node-list-empty? titleabb)
	    (if (node-list-empty? metatitle)
		title
		metatitle)
	    titleabb)
	metatabb)))
  
(define ($refentry-header-footer-element$)
  (let* ((refdescriptor (node-list-first 
			 (select-elements 
			  (descendants (current-node)) "REFDESCRIPTOR")))
	 (refname       (node-list-first 
			 (select-elements 
			  (descendants (current-node)) "REFNAME")))
         (refentrytitle (node-list-first 
			 (select-elements 
			  (descendants (current-node)) "REFENTRYTITLE"))))
    (if (node-list-empty? refentrytitle)
	(if (node-list-empty? refdescriptor)
	    refname
	    refdescriptor)
	refentrytitle)))

(define ($title-header-footer$)
  (let* ((title (if (equal? (gi) "REFENTRY")
		   ($refentry-header-footer-element$)
		   ($title-header-footer-element$))))
    (make sequence
      use: para-style
      font-posture: 'italic
      (with-mode hf-mode 
	(process-node-list title)))))

(define ($page-number-header-footer$) 
  (let ((component (ancestor-member (current-node) 
				    (append division-element-list
					    component-element-list))))
    (make sequence
      font-posture: 'italic
      (literal 
       %gentext-page%
       (if %page-number-restart%
	   (case (gi component)
	     (("APPENDIX" ) 
	      (string-append
	       (element-label component #t)
	       (gentext-intra-label-sep "_pagenumber")))
;;	     (("ARTICLE") (gentext-element-name "ARTICLE"))
;;	     (("BIBLIOGRAPHY") (gentext-element-name "BIBLIOGRAPHY"))
;;	     (("BOOK") (gentext-element-name "BOOK"))
	     (("CHAPTER")
	      (string-append
	       (element-label component #t)
	       (gentext-intra-label-sep "_pagenumber")))
;;	     (("GLOSSARY") (gentext-element-name "GLOSSARY"))
;;	     (("INDEX") (gentext-element-name "INDEX"))
;;	     (("PART") (gentext-element-name "PART"))
;;	     (("PREFACE") (gentext-element-name "PREFACE"))
;;	     (("REFENTRY") (gentext-element-name "REFENTRY"))
;;	     (("REFERENCE") (gentext-element-name "REFERENCE"))
	     (else ""))
	   ""))
      (page-number-sosofo))))

(define (first-page-inner-header gi)
  (empty-sosofo))

(define (first-page-center-header gi)
  (empty-sosofo))

(define (first-page-outer-header gi)
  (empty-sosofo))

(define (page-inner-header gi)
  (empty-sosofo))

(define (page-center-header gi)
  (empty-sosofo))

(define (page-outer-header gi)
  (case gi
    (("DEDICATION") (empty-sosofo))
    (("LOT") (empty-sosofo))
    (("PART") (empty-sosofo))
    (("TOC") (empty-sosofo))
    (else ($title-header-footer$))))

(define (first-page-inner-footer gi)
  (empty-sosofo))

(define (first-page-center-footer gi)
  (empty-sosofo))

(define (first-page-outer-footer gi)
  (case gi
    (("DEDICATION") (empty-sosofo))
    (("PART") (empty-sosofo))
    (else ($page-number-header-footer$))))

(define (page-inner-footer gi)
  (empty-sosofo))

(define (page-center-footer gi)
  (empty-sosofo))

(define (page-outer-footer gi)
  ($page-number-header-footer$))

(define ($page-number-format$ #!optional (gi (gi)))
  (case gi
    (("TOC") "i")
    (("LOT") "i")
    (("PREFACE") "i")
    (else "1")))

(define ($left-header$ #!optional (gi (gi)))
  (if-first-page
   (if (equal? %writing-mode% 'left-to-right)
       (first-page-inner-header gi)
       (first-page-outer-header gi))
   (if %two-side%
       (if-front-page
	(if (equal? %writing-mode% 'left-to-right)
	    (page-inner-header gi)
	    (page-outer-header gi))
	(if (equal? %writing-mode% 'left-to-right)
	    (page-outer-header gi)
	    (page-inner-header gi)))
       (if (equal? %writing-mode% 'left-to-right)
	   (page-inner-header gi)
	   (page-outer-header gi)))))

(define ($center-header$ #!optional (gi (gi)))
  (if-first-page
   (first-page-center-header gi)
   (page-center-header gi)))

(define ($right-header$ #!optional (gi (gi)))
  (if-first-page
   (if (equal? %writing-mode% 'left-to-right)
       (first-page-outer-header gi)
       (first-page-inner-header gi))
   (if %two-side%
       (if-front-page
	(if (equal? %writing-mode% 'left-to-right)
	    (page-outer-header gi)
	    (page-inner-header gi))
	(if (equal? %writing-mode% 'left-to-right)
	    (page-inner-header gi)
	    (page-outer-header gi)))
       (if (equal? %writing-mode% 'left-to-right)
	   (page-outer-header gi)
	   (page-inner-header gi)))))

(define ($left-footer$ #!optional (gi (gi)))
  (if-first-page
   (if (equal? %writing-mode% 'left-to-right)
       (first-page-inner-footer gi)
       (first-page-outer-footer gi))
   (if %two-side%
       (if-front-page
	(if (equal? %writing-mode% 'left-to-right)
	    (page-inner-footer gi)
	    (page-outer-footer gi))
	(if (equal? %writing-mode% 'left-to-right)
	    (page-outer-footer gi)
	    (page-inner-footer gi)))
       (if (equal? %writing-mode% 'left-to-right)
	   (page-inner-footer gi)
	   (page-outer-footer gi)))))

(define ($center-footer$ #!optional (gi (gi)))
  (if-first-page
   (first-page-center-footer gi)
   (page-center-footer gi)))

(define ($right-footer$ #!optional (gi (gi)))
  (if-first-page
   (if (equal? %writing-mode% 'left-to-right)
       (first-page-outer-footer gi)
       (first-page-inner-footer gi))
   (if %two-side%
       (if-front-page
	(if (equal? %writing-mode% 'left-to-right)
	    (page-outer-footer gi)
	    (page-inner-footer gi))
	(if (equal? %writing-mode% 'left-to-right)
	    (page-inner-footer gi)
	    (page-outer-footer gi)))
       (if (equal? %writing-mode% 'left-to-right)
	   (page-outer-footer gi)
	   (page-inner-footer gi)))))

(define ($component$)
  (make simple-page-sequence
    page-number-restart?: (or %page-number-restart% 
			      (book-start?) 
			      (first-chapter?))
    page-number-format: ($page-number-format$)
    use: para-style ;; set defaults for text in this simple page sequence
    left-header:   ($left-header$)
    center-header: ($center-header$)
    right-header:  ($right-header$)
    left-footer:   ($left-footer$)
    center-footer: ($center-footer$)
    right-footer:  ($right-footer$)
    start-indent: %body-start-indent%
    input-whitespace-treatment: 'collapse
    quadding: %default-quadding%
    (make sequence
      ($component-title$)
      (process-children))
    (make-endnotes)))

(define ($component-title$)
  (let* ((info (cond
		((equal? (gi) "APPENDIX")
		 (select-elements (children (current-node)) "DOCINFO"))
		((equal? (gi) "ARTICLE")
		 (select-elements (children (current-node)) "ARTHEADER"))
		((equal? (gi) "BIBLIOGRAPHY")
		 (select-elements (children (current-node)) "DOCINFO"))
		((equal? (gi) "CHAPTER")
		 (select-elements (children (current-node)) "DOCINFO"))
		((equal? (gi) "DEDICATION")
		 (empty-node-list))
		((equal? (gi) "GLOSSARY")
		 (select-elements (children (current-node)) "DOCINFO"))
		((equal? (gi) "INDEX")
		 (select-elements (children (current-node)) "DOCINFO"))
		((equal? (gi) "PREFACE")
		 (select-elements (children (current-node)) "DOCINFO"))
		((equal? (gi) "REFERENCE")
		 (select-elements (children (current-node)) "DOCINFO"))
		((equal? (gi) "SETINDEX")
		 (select-elements (children (current-node)) "DOCINFO"))
		(else
		 (empty-node-list))))
	 (exp-children (if (node-list-empty? info)
			   (empty-node-list)
			   (expand-children (children info) '("BOOKBIBLIO" 
							      "BIBLIOMISC"
							      "BIBLIOSET"))))
	 (parent-titles (select-elements (children (current-node)) "TITLE"))
	 (info-titles   (select-elements exp-children "TITLE"))
	 (titles        (if (node-list-empty? parent-titles)
			    info-titles
			    parent-titles))
	 (subtitles     (select-elements exp-children "SUBTITLE")))
    (make sequence
      (make paragraph
	font-family-name: %title-font-family%
	font-weight: 'bold
	font-size: (HSIZE 4)
	line-spacing: (* (HSIZE 4) %line-spacing-factor%)
	space-before: (* (HSIZE 4) %head-before-factor%)
	start-indent: 0pt
	first-line-start-indent: 0pt
	quadding: %component-title-quadding%
	keep-with-next?: #t

	(if (string=? (element-label) "")
	    (empty-sosofo)
	    (literal (gentext-element-name-space (gi))
		     (element-label)
		     (gentext-label-title-sep (gi))))

	(if (node-list-empty? titles)
	    (element-title-sosofo) ;; get a default!
	    (with-mode component-title-mode
	      (make sequence
		(process-node-list titles)))))

      (make paragraph
	font-family-name: %title-font-family%
	font-weight: 'bold
	font-posture: 'italic
	font-size: (HSIZE 3)
	line-spacing: (* (HSIZE 3) %line-spacing-factor%)
	space-before: (* 0.5 (* (HSIZE 3) %head-before-factor%))
	start-indent: 0pt
	first-line-start-indent: 0pt
	quadding: %component-subtitle-quadding%
	keep-with-next?: #t

	(with-mode component-title-mode
	  (make sequence
	    (process-node-list subtitles))))

      (make paragraph
	space-after: (* (HSIZE 4) %head-after-factor%)
	(literal " ")))))

(mode component-title-mode
  (element TITLE
    (process-children))

  (element SUBTITLE
    (process-children))
)

;; this is how we prevent the title in the header from acquiring the
;;   display treatment that it receives in the body of the document
;;
(mode hf-mode
  (element TITLE
    (let* ((component (ancestor-member (current-node) component-element-list))
	   (chaporapp (or (equal? (gi component) "CHAPTER")
			  (equal? (gi component) "APPENDIX"))))
      (if %chap-app-running-heads%
	  (make sequence
	    (if (and chaporapp
		     %chapter-autolabel%
		     (or %chap-app-running-head-autolabel%
			 (attribute-string "LABEL" component)))
		(literal (gentext-element-name-space (gi component))
			 (element-label component)
			 (gentext-label-title-sep (gi component)))
		(empty-sosofo))
	    (process-children-trim))
	  (empty-sosofo))))

  (element TITLEABBREV
    (if %chap-app-running-heads%
	(make sequence
	  (if (or (have-ancestor? "CHAPTER")
		  (have-ancestor? "APPENDIX"))
	      (literal (gentext-element-name-space (gi (parent)))
		       (element-label (parent))
		       (gentext-label-title-sep (gi (parent))))
	      (empty-sosofo))
	  (process-children-trim))
	(empty-sosofo)))

  (element REFENTRYTITLE
    (if %chap-app-running-heads%
	(process-children-trim)
	(empty-sosofo)))

  (element REFDESCRIPTOR
    (if %chap-app-running-heads%
	(process-children-trim)
	(empty-sosofo)))

  (element REFNAME
    (if %chap-app-running-heads%
	(process-children-trim)
	(empty-sosofo)))

  ;; Graphics aren't allowed in headers and footers...
  (element GRAPHIC
    (empty-sosofo))

  (element INLINEGRAPHIC
    (empty-sosofo))
)

(element APPENDIX ($component$))
(element (APPENDIX TITLE) (empty-sosofo))

(element CHAPTER ($component$))
(element (CHAPTER TITLE) (empty-sosofo))

(element PREFACE ($component$))
(element (PREFACE TITLE) (empty-sosofo))

;; Dedication is empty except in a special mode so that it can be
;; reordered (made to come before the TOCs)
(element DEDICATION (empty-sosofo))
(mode dedication-page-mode
  (element DEDICATION ($component$))
  (element (DEDICATION TITLE) (empty-sosofo))
)

(element ARTICLE ($component$))
