/*
 *
 * swapout.c  -- Dirty 5Meg of memory, trying to force the machine to
 * swap out processes.
 *
 * Written by Kai Harrekilde-Petersen, Jan 22, 1996.
 * Freely distributable under the GNU General Public License; see the
 * file COPYING for details.
 *
 * Modified by Claus-Justus Heine to accept a command line argument that
 * specifies the number of megabytes to allocate.
 */

 char swp_src[] = "$Source: /homes/cvs/ftape-stacked/contrib/swapout/swapout.c,v $";
 char swp_rev[] = "$Revision: 1.4 $";
 char swp_dat[] = "$Date: 1997/07/30 02:05:22 $";

#include <stdlib.h>
#include <stdio.h>
#include <asm/page.h>
#include <errno.h>


#define MEM_SIZE (5 * 1024 * 1024)

void usage(char *prog_name, int retval) 
{
	fprintf(stderr, "Usage: %s [megabytes]\n", prog_name);
	fprintf(stderr, "The optional parameter \"megabytes\" defaults to %d\n", MEM_SIZE/1024/1024);	
	exit(retval);
}

int main(int argc, char **argv)
{
	char *ptr = NULL;
	int i;
	int mem_size = MEM_SIZE;

	switch(argc) {
	case 1:break;
	case 2: {
		if (strcmp(argv[1], "-h") == 0 || strcmp(argv[1], "--help") == 0) {
			usage(argv[0], 0);
		} else {
			mem_size = 1024*1024*atoi(argv[1]);
		}
		break;
	}
	default: usage(argv[0], 1); break;
	}
	printf("Trying to allocate %d Meg\n", mem_size/1024/1024);
	ptr = malloc(mem_size);
	if (!ptr) {
		fprintf( stderr, "Couldn't allocate %d Meg. "
			 "You need kill off a few programs.\n", mem_size/1024/1024 );
		exit(-ENOMEM);
	}
	for (i = 0; i < mem_size / PAGE_SIZE; i++) {
		ptr[i * PAGE_SIZE] = i;
	}
	free(ptr);
	exit(0);
}
