/*
 * Copyright (C) 1998 Craig Knudsen, cknudsen@radix.net
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * Description:
 *	Helps you keep track of time spent on different tasks.
 *
 * Author:
 *	Craig Knudsen, cknudsen@radix.net, http://www.radix.net/~cknudsen
 *
 * Home Page:
 *	http://www.radix.net/~cknudsen/gtimer/
 *
 * History:
 *	04-Apr-98	Created
 *			(Code stolen from another project/program I wrote.)
 *
 ****************************************************************************/


#ifndef _CONFIG_H
#define _CONFIG_H

/* config file parameters */

#define CONFIG_DEFAULT_FILE		".gtimerrc"

#define CONFIG_SORT			"sort"
#define CONFIG_SORT_FORWARD		"sort-dir"
#define CONFIG_PRINT			"print"
#define CONFIG_VERSION			"version"

/* default values */
#ifdef CONFIG_DEFAULTS
static char *default_config[] = {
  CONFIG_SORT, "0",
  CONFIG_SORT_FORWARD, "1",
  CONFIG_PRINT, "lpr",
  NULL,
};
#endif

int configReadAttributes (
#ifndef _NO_PROTO
  char *attrfile
#endif
);
int configGetAttribute (
#ifndef _NO_PROTO
  char *attribute, char **value
#endif
);
int configSetAttribute (
#ifndef _NO_PROTO
  char *attribute, char *value
#endif
);
int configSaveAttributes (
#ifndef _NO_PROTO
  char *attrfile
#endif
);
int configModified ();
void configClear ();

#endif /* _CONFIG_H */
