/*
 * dfile.c - SGI IRIX file processing functions for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dfile.c,v 1.7 98/03/06 08:22:13 abe Exp $";
#endif


#include "lsof.h"


/*
 * is_file_named() - is this file named?
 */

int
is_file_named(p, ty)
	char *p;			/* path name; NULL = search by device
					 * and inode (from *Lf) */

#if	IRIXV>=50101
	vtype_t ty;			/* vnode type */
#else	/* IRIXV<50101 */
	int ty;				/* inode type */
#endif	/* IRIXV>=50101 */

{
	int f;
	struct sfile *s;
/*
 * Search the file chain.
 */
	for (f = 0, s = Sfile; s; s = s->next) {

	/*
	 * Search by path name, as requested.
	 */
	    if (p) {
		if (strcmp(p, s->aname) == 0 || strcmp(p, s->name)  == 0) {
		    f = 2;
		    break;
		}
		continue;
	    }
	/*
	 * Check for a clone file.
	 */

#if    IRIXV<50101
	    if (Lf->is_com && Lf->dev_def)
#endif	/* IRIXV<50101 */

	    {

		if (major(s->dev) == USEMA_MAJOR
		&&  major(Lf->dev) == USEMA_MAJOR) {
		    f = 1;
		    break;
		}

#if    IRIXV<50101
		if (major(s->dev) == CLN2_MAJOR
#else	/* IRIXV>=50101 */
		if (major(s->dev) == CLN_MAJOR
#endif	/* IRIXV<50101 */

		&&  major(Lf->dev) == minor(s->dev)) {
		    f = 1;
		    break;
		}
	    }
	/*
	 * Check for a regular file or directory -- the device and
	 * inode numbers must match.
	 */
	    if (Lf->dev_def && s->type) {

#if	IRIXV>=50300 && IRIXV<60400
	    /*
	     * If this is an IRIX >= 5.3 and < 6.4 VCHR file, see if it is
	     * a TPSC device.  If it is, and if its device number and the
	     * device number of the file chain entry are the same, ignore
	     * inode numbers and report a successful match.
	     */
		if (ty == VCHR
		&&  major(Lf->dev) >= TPSC_MAJOR
		&&  major(Lf->dev) < TPSC_STAT_MAJOR
		&&  Lf->dev == s->dev) {
		    f = 1;
		    break;
		}
#endif	/* IRIXV>=50300 && IRIXV<60400 */

		if (Lf->dev == s->dev && (ino_t)Lf->inode == s->i) {
		    f = 1;
		    break;
		}
		continue;
	    }
	/*
	 * Check for a file system match.
	 * Try to avoid matching character files to non-character devices.
	 */
	    if (Lf->dev_def && Lf->dev == s->dev

#if    IRIXV<50101
	    &&  (ty != IFCHR || s->mode == S_IFCHR)
#else	/* IRIXV>=50101 */
	    &&  (ty != VCHR  || s->mode == S_IFCHR)
#endif	/* IRIXV<50101 */

	    ) {
		f = 1;
		break;
	    }
	}
/*
 * Convert the name if a match occurred.
 */
	if (f) {
	    if (f == 2)
		(void) strcpy(Namech, p);
	    else {
		(void) strcpy(Namech, s->name);
		if (s->devnm)
		    (void) sprintf(endnm(), " (%s)", s->devnm);
	    }
	    s->f = 1;
	    return(1);
	}
	return(0);
}


/*
 * process_file() - process file
 */

void
process_file(fp)
	KA_T fp;		/* kernel file structure address */
{
	struct file f;
	int flag;

	if (kread(fp, (char *)&f, sizeof(f))) {
	    enter_nm("can't read file struct");
	    return;
	}
	Lf->off = (SZOFFTYPE)f.f_offset;

	if (f.f_count) {

	/*
	 * Construct access code.
	 */
	    if ((flag = (f.f_flag & (FREAD | FWRITE))) == FREAD)
		Lf->access = 'r';
	    else if (flag == FWRITE)
		Lf->access = 'w';
	    else if (flag == (FREAD | FWRITE))
		Lf->access = 'u';
	/*
	 * Process structure.
	 */

#if	IRIXV<50101
	    process_node((KA_T)f.f_inode);
#else	/* IRIXV>=50101 */
# if	IRIXV>=60400
	    if (f.f_flag & FSOCKET) {
		KA_T sa;
		struct vsocket {
		    KA_T d1;
		    bhv_head_t s_bh;
		} vs;

		if (!f.f_vsock
		||  kread((KA_T)f.f_vsock, (char *)&vs, sizeof(vs))
		||  !(sa = getbhvpdata(&vs.s_bh)))
		    enter_nm("no socket structure information");
		else
		    process_socket(sa);
	        return;
	    }
# endif	/* IRIXV>=60400 */
	    process_node((KA_T)f.f_vnode);
#endif	/* IRIXV<50101 */

	    return;
	}
	enter_nm("no more information");
}
