#include "config.h"
#include "pscol.h"

/********************************************************************/
/*                                                                  */
/* buildpsfile: reads PS_COLORS and/or TOP_COLORS and writes <file> */
/*              will convert uids if told to                        */
/*                                                                  */
/********************************************************************/

void buildpsfile(char *filename, int type, int convuid, int convpls,
                 int convtyp, int convcol, int verbose)
{
 char *psv, *topv;
 int mask;
 FILE *pscol;

 if (verbose) info("Getting environment variables");
 psv = getenv("PS_COLORS");
 topv = getenv("TOP_COLORS");
 if ((type == 1 && psv == NULL) || (type == 2 && topv == NULL))
  error("can't read %s_COLORS environment variable", type == 1?"PS":"TOP");
 else if (psv == NULL || topv == NULL)
  error("can't read PS_COLORS and/or TOP_COLORS environment variable\n");
 if (!strcmp(filename, "-"))
  pscol = stdout;
 else
  if ((pscol = fopen(filename, "w")) == NULL)
   error("cannot open %s for writing\n", filename);
 fprintf(pscol, "#!%s\n%s\n", progname, NEW_FILE_HEADER);
 if (type == 0 || type == 1)
 {
  if (verbose) info("Parsing variables");
  fprintf(pscol, "[%s]\n%s", strcmp(psv, topv)?"PS":"COMMON",
          convert(parsevar(psv), convpls, convuid, convcol, convtyp, verbose));
 }
 if ((type == 0 || type == 2) && strcmp(psv, topv))
 {
  if (type != 0 && verbose) info("Parsing variables");
  fprintf(pscol, "%s[TOP]\n%s", type == 0?"\n":"", convert(parsevar(topv),
          convpls, convuid, convcol, convtyp, type == 0?0:verbose));
 }
 fclose(pscol);
 mask = umask(0);
 chmod(filename, 0777 & ~mask);
 umask(mask);
}
