/* Ruari Diff, another program to do something or other */
/* Copyright (C) 1997, James Troup <jjtroup@comp.brad.ac.uk> */

/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <sys/types.h>
#include <db.h>

#ifndef HASH_H
#define HASH_H

#define PACKAGE_STR_LENGTH 35
#define VERSION_STR_LENGTH 35
#define PRIORTY_STR_LENGTH 25
#define SECTION_STR_LENGTH 25

struct package_info {
  char package_name[PACKAGE_STR_LENGTH];
  char version[VERSION_STR_LENGTH];
  char priority[PRIORTY_STR_LENGTH];
  char section[SECTION_STR_LENGTH];
};

void create_hash_table(void);

void add_to_hash_table (const char *package, const char *version, 
			const char *priority, const char *section);

struct package_info *get_from_hash_table (const char *package);

void destroy_hash_table(void);

u_int32_t hash_function (const void *string, size_t size);
#endif
