/*
 *
 *
 *
 *
 */

#include "arena.h"
#include "WWWLib.h"
#include "HTAAUtil.h"
#include "HTAlert.h"

#include "debug.h"
#include "status.h"
#include "util.h"


/*
 * Arena user prompt for line of input. Echo on/off controlled by AlertOpCode.
 */
static BOOL AskUserConfirmation(HTRequest* theRequest,
				HTAlertOpcode theAlertOpCode,
				int msgnum, const char* Default,
				void* input, HTAlertPar* reply)
{
 Bool status = False;
#ifdef ARENA_DEBUG
 char Iam[] = "AskUserConfirmation";
#endif


#ifdef ARENA_DEBUG
 if (AUTHENTICATION_TRACE)
   {
    Arena_TracePrint(Iam,
		     " message id = %d, AlertOpCode = 0x%x,\n",
		     msgnum, theAlertOpCode);
    if (input) Arena_DebugPrint("\t%s\n", (char*)input);
    if (Default) Arena_DebugPrint("\tRETURN for [%s]\n", (char*)Default);
   }
#endif

 if (theAlertOpCode == HT_A_CONFIRM)
   {
    if (reply && msgnum >= 0)
      {
       char* userReply;

       if (Arena_StrLen(userReply = ArenaPromptUser((char*)input,
						    (char*)Default,
						    True)))
	 {
	  if (tolower(*userReply == 'y')) status = True;
	  Free(userReply);
	 }
      }
   }

 return (BOOL)status;
}


/*
 * Arena user prompt for line of input. Echo on/off controlled by AlertOpCode.
 */
static BOOL ReadLine(HTRequest* theRequest,
		     HTAlertOpcode theAlertOpCode,
		     int msgnum, const char* Default,
		     void* input, HTAlertPar* reply)
{
 Bool status = True;
 Bool EchoOn = True;
#ifdef ARENA_DEBUG
 char Iam[] = "ReadLine";
#endif


#ifdef ARENA_DEBUG
 if (AUTHENTICATION_TRACE)
   {
    Arena_TracePrint(Iam,
		     " message id = %d, AlertOpCode = 0x%x,\n",
		     msgnum, theAlertOpCode);
    if (input) Arena_DebugPrint("\t%s\n", (char*)input);
    if (Default) Arena_DebugPrint("\tRETURN for [%s]\n", (char*)Default);
   }
#endif

 switch (theAlertOpCode)
   {
    case HT_A_PROMPT:
      EchoOn = True;
      break;

    case HT_A_SECRET:
      EchoOn = False;
      break;

    default:
      return NO;
      break;
   }

 if (reply && msgnum >= 0)
   {
    char* userReply;

    if (Arena_StrLen(userReply = ArenaPromptUser((char*)input, (char*)Default,
						 EchoOn)))
      {
       HTAlert_setReplyMessage(reply, userReply);
       Free(userReply);
      }
     else
      if (Default)
	HTAlert_setReplyMessage(reply, (char*)Default);
       else
	status = False;
   }
  else
   status = False;

 return (BOOL)status;
}


/*
 * Arena user prompt for ``Username+Password'' callback function.
 */
static BOOL ReadUsernameAndPassword(HTRequest* theRequest,
				    HTAlertOpcode theAlertOpCode,
				    int msgnum, const char* Default,
				    void* input, HTAlertPar* reply)
{
 Bool status = True;
#ifdef ARENA_DEBUG
 char Iam[] = "ReadUsernameAndPassword";
#endif


#ifdef ARENA_DEBUG
 if (AUTHENTICATION_TRACE)
   {
    Arena_TracePrint(Iam, " message id = %d,\n", msgnum);
    if (input) Arena_DebugPrint("\t%s\n", (char*)input);
    if (Default) Arena_DebugPrint("\tRETURN for [%s]\n", (char*)Default);
   }
#endif

 if (reply && msgnum >= 0)
   {
    char* theUserName;

    if (Arena_StrLen(theUserName = ArenaPromptUser(_("Username?"), NULL,True)))
      {
       HTAlert_setReplyMessage(reply, theUserName);
       Free(theUserName);
      }
     else
      if (Default)
	HTAlert_setReplyMessage(reply, (char*)Default);
       else
	status = False;

    if (status)
      {
       char* thePassword;

       thePassword = ArenaPromptUser(_("Password?"), NULL, False);
       HTAlert_setReplySecret(reply, thePassword);
       Free(thePassword);
      }
   }
  else
   status = False;

 return (BOOL)status;
}


/*
 * Register BASIC access authentication scheme.
 */
void ArenaDialogInit(void)
{
 HTAlert_add(AskUserConfirmation, HT_A_CONFIRM);
 HTAlert_add(ReadLine, HT_A_PROMPT);
 HTAlert_add(ReadLine, HT_A_SECRET);
 HTAlert_add(ReadUsernameAndPassword, HT_A_USER_PW);

 HTAlert_setInteractive(YES);
}
