#ifndef ___ARENA_PARSEHTML_I_H___
#  define ___ARENA_PARSEHTML_I_H___

/*
 * Header file for parsehtml.h for internal use. Publics go to "parsehtml.h".
 */

#include "types.h"


/*
 * HTML error codes displayed in Octal
 */
#define ERR_ANCHOR  1 << 0
#define ERR_EMPH    1 << 1
#define ERR_HEADER  1 << 2

#define ERR_UL      1 << 3
#define ERR_OL      1 << 4
#define ERR_DL      1 << 5

#define ERR_SELECT  1 << 6
#define ERR_BLOCK   1 << 7
#define ERR_PRE     1 << 8
#define ERR_FIG     1 << 13

#define ERR_LI      1 << 9
#define ERR_TABLE   1 << 10
#define ERR_SETUP   1 << 11
#define ERR_BODY    1 << 12


/*
 * window margin and indents
 */
#define MAXMARGIN       (win_width - sbar_width - 4)
#define MININDENT       0 /* 4 */
#define NESTINDENT      5
#define GLINDENT        30
#define OLINDENT        3
#define LINDENT         8
#define GLGAP           4


/*
 * store current/max number of columns in first element
 */
#define COLS(widths)    widths->Cmin
#define MAXCOLS(widths) widths->Cmax
#define NCOLS		15


/* structure for table widths - index from 1
 * upwards as zeroth entry used for book keeping
 */
typedef struct t_width
{
 int left;
 int right;
 int Cmin;	/* reused for row height in 2nd pass */
 int Cmax;	/* we track min/max width of columns */
 int rows;	/* row span count for each column */
} ColumnWidth;

typedef struct valid_tokens
 {
  char *Txt;
  int Len;
  int Name;
  int Class;
  Bool SpecialCase;
 } VALIDTokens;

VALIDTokens ARENA_ValidTokens[] =
    {
     { "a",           1, TAG_ANCHOR,    EN_TEXT,    0 },
     { "alt",         3, TAG_ALT,       EN_BLOCK,   0 },
     { "added",       5, TAG_ADDED,     EN_TEXT,    0 },
     { "applet",      6, TAG_APPLET,    EN_TEXT,    TAG_APPLET },
     { "address",     7, TAG_ADDRESS,   EN_BLOCK,   0 },
     { "abstract",    8, TAG_ABSTRACT,  EN_BLOCK,   0 },
     { "b",           1, TAG_BOLD,      EN_TEXT,    0 },
     { "br",          2, TAG_BR,        EN_TEXT,    0 },
     { "body",        4, TAG_BODY,      EN_MAIN,    TAG_BODY },
     { "blockquote", 10, TAG_QUOTE,     EN_BLOCK,   0 },
     { "base",        4, TAG_BASE,      EN_SETUP,   0 },
     { "center",      6, TAG_CENTER,    EN_TEXT,    0 },
     { "code",        4, TAG_CODE,      EN_TEXT,    0 },
     { "cite",        4, TAG_CITE,      EN_TEXT,    0 },
     { "caption",     7, TAG_CAPTION,   EN_BLOCK,   0 },
     { "dfn",         3, TAG_DFN,       EN_TEXT,    0 },
     { "dir",         3, TAG_UL,        EN_LIST,    0 },
     { "dl",          2, TAG_DL,        EN_LIST,    0 },
     { "dt",          2, TAG_DT,        EL_DEFLIST, 0 },
     { "dd",          2, TAG_DD,        EL_DEFLIST, 0 },
     { "em",          2, TAG_EM,        EN_TEXT,    0 },
     { "fig",         3, TAG_FIG,       EN_BLOCK,   0 },
     { "form",        4, TAG_FORM,      EN_TEXT,    0 },
     { "head",        4, TAG_HEAD,      EN_SETUP,   TAG_HEAD },
     { "h1",          2, TAG_H1,        EN_HEADER,  0 },
     { "h2",          2, TAG_H2,        EN_HEADER,  0 },
     { "h3",          2, TAG_H3,        EN_HEADER,  0 },
     { "h4",          2, TAG_H4,        EN_HEADER,  0 },
     { "h5",          2, TAG_H5,        EN_HEADER,  0 },
     { "h6",          2, TAG_H6,        EN_HEADER,  0 },
     { "hr",          2, TAG_HR,        EN_BLOCK,   0 },
     { "i",           1, TAG_ITALIC,    EN_TEXT,    0 },
     { "img",         3, TAG_IMG,       EN_TEXT,    0 },
     { "input",       5, TAG_INPUT,     EN_TEXT,    0 },
     { "isindex",     7, TAG_ISINDEX,   EN_SETUP,   TAG_ISINDEX },
     { "kbd",         3, TAG_KBD,       EN_TEXT,    0 },
     { "li",          2, TAG_LI,        EN_LIST,    0 },
     { "link",        4, TAG_LINK,      EN_SETUP,   0 },
     { "math",        4, TAG_MATH,      EN_TEXT,    0 },
     { "margin",      6, TAG_MARGIN,    EN_TEXT,    0 },
     { "menu",        4, TAG_UL,        EN_LIST,    0 },
     { "note",        4, TAG_NOTE,      EN_BLOCK,   0 },
     { "ol",          2, TAG_OL,        EN_LIST,    0 },
     { "option",      6, TAG_OPTION,    EN_TEXT,    0 },
     { "p",           1, TAG_P,         EN_BLOCK,   0 },
     { "pre",         3, TAG_PRE,       EN_BLOCK,   0 },
     { "q",           1, TAG_Q,         EN_TEXT,    0 },
     { "quote",       5, TAG_QUOTE,     EN_BLOCK,   0 },
     { "removed",     7, TAG_REMOVED,   EN_TEXT,    0 },
     { "s",           1, TAG_STRIKE,    EN_TEXT,    0 },
     { "sup",         3, TAG_SUP,       EN_TEXT,    0 },
     { "sub",         3, TAG_SUB,       EN_TEXT,    0 },
     { "samp",        4, TAG_SAMP,      EN_TEXT,    0 },
     { "small",       5, TAG_SMALL,     EN_TEXT,    0 },
     { "strong",      6, TAG_STRONG,    EN_TEXT,    0 },
     { "select",      6, TAG_SELECT,    EN_TEXT,    0 },
     { "strike",      6, TAG_STRIKE,    EN_TEXT,    0 },
     { "style",       5, TAG_STYLE,     EN_SETUP,   0 },
     { "title",       5, TAG_TITLE,     EN_SETUP,   0 },
     { "tt",          2, TAG_TT,        EN_TEXT,    0 },
     { "tr",          2, TAG_TR,        EN_TABLE,   0 },
     { "th",          2, TAG_TH,        EN_TABLE,   0 },
     { "td",          2, TAG_TD,        EN_TABLE,   0 },
     { "table",       5, TAG_TABLE,     EN_BLOCK,   0 },
     { "textarea",    8, TAG_TEXTAREA,  EN_TEXT,    0 },
     { "u",           1, TAG_UNDERLINE, EN_TEXT,    0 },
     { "ul",          2, TAG_UL,        EN_LIST,    0 },
     { "var",         3, TAG_VAR,       EN_TEXT,    0 },
     { "xmp",         2, TAG_PRE,       EN_BLOCK,   0 },
     { NULL,          0, UNKNOWN,       EN_UNKNOWN, 0 }
    };

#define ARENA_ValidTokensABC_COUNTER 256
VALIDTokens* ARENA_ValidTokensABC[ARENA_ValidTokensABC_COUNTER] = { NULL };

int GetToken(void);
int CompoundTextWidth(char *s, int start, int len, int *space_p);


#endif /* ifndef ___ARENA_PARSEHTML_I_H___ */
