#ifndef ___ARENA_STYLE_TYPES_H___
#  define ___ARENA_STYLE_TYPES_H___

/*
 * Types.
 */


#include "defs.h"
#include "types.h"
#include "image_types.h"


typedef struct BG_Style    /* --Spif 20-Oct-95 style background struct */
{
 int            flag;      /* flag -> no bg, use colour, use pixmap,
			      repeat mode... */
 int            x_pos;
 int            y_pos;
 unsigned char  r, g, b;   /* colour using RGB,
			      must add the same thing for text or
			      foreground colour */
 Image          *image;
} BG_Style;


typedef enum _StyleExternalProperty
{
 ArenaSE_UNKNOWN,

 ArenaSE_FONT_SIZE,
 ArenaSE_FONT_FAMILY,
 ArenaSE_FONT_WEIGHT,
 ArenaSE_FONT_STYLE,
 ArenaSE_LINE_HEIGHT,
 ArenaSE_FONT,

 ArenaSE_COLOUR,
 ArenaSE_BACKGROUND,
 ArenaSE_BG_BLEND_DIRECTION,
 ArenaSE_BG_STYLE,
 ArenaSE_BG_POSITION,

 ArenaSE_WORD_SPACING,
 ArenaSE_LETTER_SPACING,
 ArenaSE_TEXT_DECORATION,

 ArenaSE_VERTICAL_ALIGN,
 ArenaSE_TEXT_TRANSFORM,
 ArenaSE_TEXT_ALIGN,
 ArenaSE_TEXT_INDENT,

 ArenaSE_PADDING,
 ArenaSE_MARGIN_TOP,
 ArenaSE_MARGIN_RIGHT,
 ArenaSE_MARGIN_BOTTOM,
 ArenaSE_MARGIN_LEFT,
 ArenaSE_MARGIN,

 ArenaSE_DISPLAY,
 ArenaSE_WIDTH,
 ArenaSE_HEIGHT,
 ArenaSE_FLOAT,
 ArenaSE_CLEAR,
 ArenaSE_PACK,

 ArenaSE_BORDER_STYLE,
 ArenaSE_BORDER_STYLE_INTERNAL,
 ArenaSE_BORDER_WIDTH,
 ArenaSE_BORDER_WIDTH_INTERNAL,
 ArenaSE_BORDER_COLOUR,
 ArenaSE_BORDER_COLOUR_INTERNAL,

 ArenaSE_LIST_STYLE,
 ArenaSE_MAGNIFICATION,
 ArenaSE_WHITE_SPACE,

 SP_NPROPERTY
} StyleExternalProperty;

typedef enum _StyleInternalProperty
{
 ArenaSI_UNKNOWN, 

 ArenaSI_FONT_SIZE,
 ArenaSI_FONT_FAMILY,
 ArenaSI_FONT_WEIGHT,
 ArenaSI_FONT_STYLE_SLANT,
 ArenaSI_FONT_STYLE_SMALL_CAPS,
 ArenaSI_LINE_HEIGHT,
 ArenaSI_FONT,

 ArenaSI_COLOUR,
 ArenaSI_BACKGROUND,            /* soon obsolete */
 ArenaSI_BACKGROUND_COLOUR,
 ArenaSI_BACKGROUND_IMAGE,

 ArenaSI_BACKGROUND_BLEND_DIRECTION,

 ArenaSI_BACKGROUND_STYLE_REPEAT,
 ArenaSI_BACKGROUND_STYLE_SCROLL,

 ArenaSI_BACKGROUND_POSITION_X,
 ArenaSI_BACKGROUND_POSITION_Y,

 ArenaSI_WORD_SPACING,
 ArenaSI_LETTER_SPACING,
 ArenaSI_TEXT_DECORATION,

 ArenaSI_VERTICAL_ALIGN,
 ArenaSI_TEXT_TRANSFORM,
 ArenaSI_TEXT_ALIGN,
 ArenaSI_TEXT_INDENT,

 ArenaSI_PADDING_TOP,
 ArenaSI_PADDING_RIGHT,
 ArenaSI_PADDING_BOTTOM,
 ArenaSI_PADDING_LEFT,

 ArenaSI_MARGIN_TOP,
 ArenaSI_MARGIN_RIGHT,
 ArenaSI_MARGIN_BOTTOM,
 ArenaSI_MARGIN_LEFT,

 ArenaSI_DISPLAY,
 ArenaSI_WIDTH,
 ArenaSI_HEIGHT,
 ArenaSI_FLOAT,
 ArenaSI_CLEAR,
 ArenaSI_PACK,

 ArenaSI_BORDER_STYLE_TOP,
 ArenaSI_BORDER_STYLE_RIGHT,
 ArenaSI_BORDER_STYLE_BOTTOM,
 ArenaSI_BORDER_STYLE_LEFT,

 ArenaSI_BORDER_WIDTH_TOP,
 ArenaSI_BORDER_WIDTH_RIGHT,
 ArenaSI_BORDER_WIDTH_BOTTOM,
 ArenaSI_BORDER_WIDTH_LEFT,

 ArenaSI_BORDER_COLOUR_TOP,
 ArenaSI_BORDER_COLOUR_RIGHT,
 ArenaSI_BORDER_COLOUR_BOTTOM,
 ArenaSI_BORDER_COLOUR_LEFT,

 ArenaSI_LIST_STYLE,
 ArenaSI_MAGNIFICATION,
 ArenaSI_WHITE_SPACE,

 ArenaSI_NPROPERTY
} StyleInternalProperty;


typedef struct _StyleFlat  StyleFlat;
typedef struct _StyleSheet StyleSheet;


#endif /* ifndef ___ARENA_STYLE_H___ */
