/*
 * rpm2html.c : Application to generate an HTML view of an ensemble
 *              of RPM packages.
 *
 * Copyright (c) 1997 Daniel Veillard <veillard@apocalypse.org>
 * See COPYING for the status of this software.
 *
 * $Id: rpm2html.c,v 1.16 1998/02/27 20:30:12 veillard Exp $
 */

#include <config.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <time.h>

#include <rpm/rpmlib.h>

#include "rpm2html.h"
#include "rpmdata.h"
#include "html.h"
#include "language.h"

int verbose = 1;
int force = 0;

int main(int argc, char *argv[]) {
    int i;
    time_t start_time;
    int nb_config_files = 0;
    char host[200];
    int mask;

    start_time = time(NULL);
    gethostname(host, sizeof(host));
    rpm2html_rpm2html_thishost = &host[0];

    rpmReadConfigFiles(NULL, NULL, NULL, 0); /* rcfile, arch, os !!!! */

    /*
     * Ensure that all files and directories created a world readable !
     */
    mask = umask(022);

    for (i = 1; i < argc ; i++) {
        if (!strcmp(argv[i], "-lang")) {
	    i++;
	    if (i >= argc) break;
            readLanguageFile(argv[i]);
	} else if (!strcmp(argv[i], "-dumplang")) {
	    i++;
	    if (i >= argc) break;
            writeLanguageFile(argv[i]);
	    return(0);
	} else if (!strcmp(argv[i], "-force")) {
	    force++;
	} else if (!strcmp(argv[i], "-v")) {
	    verbose++;
	} else if (!strcmp(argv[i], "-q")) {
	    verbose = 0;
	} else {
	    if (readConfigFile(argv[i]) >= 0) {
		/*
		 * A config file has been found and parsed.
		 * Scan the directories, dump the results
		 * and reinitialize.
		 */
	        nb_config_files++;
		rpmDirScanAll();
		if (rpm2html_files != 0) {
		    dumpAllRessHtml(0);
		    rpmDistribSort(0);
		    dumpRpmDistribs(0);
		    rpmGroupSort(0);
		    dumpRpmGroups(0);
		    rpmVendorSort(0);
		    dumpRpmVendors(0);
		    rpmDateSort(0);
		    dumpRpmByDate(0);
		    rpmNameSort(0);
		    dumpRpmByName(0);
		    dumpIndex(start_time, 0);
		}
		if (rpm2html_install_files != 0) {
		    dumpAllRessHtml(1);
		    rpmDistribSort(1);
		    dumpRpmDistribs(1);
		    rpmGroupSort(1);
		    dumpRpmGroups(1);
		    rpmVendorSort(1);
		    dumpRpmVendors(1);
		    rpmDateSort(1);
		    dumpRpmByDate(1);
		    rpmNameSort(1);
		    dumpRpmByName(1);
		    dumpIndex(start_time, 1);
		}
                reinitialize();
            }
	}
    }

    /*
     * reset the umask
     */
    umask(mask);

    if (nb_config_files == 0) {
	fprintf(stderr, "%s %s : Web page generator for RPM packages\n",
	        RPM2HTML_NAME, RPM2HTML_VER);
        fprintf(stderr, "usage : %s [-q/-v] [-force] [-lang msgfile] configfile1 [configfile2 ...]\n", argv[0]);
        fprintf(stderr, "        %s [-dumplang msgfile]\n", argv[0]);
	exit(0);
    }

    return(0);
}

