// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1997
//  wer auch immer ...
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        tiorpcreader.h
// 
// Purpose:     
// 
// Created:     20 Feb 1997   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: a copy of rpcreader.h
// 
// $Id: tiorpcreader.h,v 1.1 1997/02/20 19:32:25 jfasch Exp $
// 
// $Log: tiorpcreader.h,v $
// Revision 1.1  1997/02/20 19:32:25  jfasch
// Initial revision
//
// 
// </file> 
#ifndef hg_dispatch_tiorpcreader_h
#define hg_dispatch_tiorpcreader_h

#include "libdispatch.h"
#include "tio.h"
#include <hyperg/utils/types.h>

class TIORpcHdr;
class TIOrpcstream;

/*
 * Read RPC requests from a client.  Derived classes initialize the
 * function array with addresses of static member functions to
 * unmarshall RPC requests and implement the virtual function called
 * when the client closes the connection.
 */

class TIORpcReader : public TransparentIOHandler {
public:
    virtual ~TIORpcReader();
protected:
    TIORpcReader(TIOrpcstream* client, int nfcns);
    TIORpcReader(const TransparentIOPtr&, int nfcns, boolean binary);

    TIOrpcstream& client();
    virtual void inputReady(const TransparentIO*);
    virtual void outputReady(const TransparentIO*) {}
    virtual TIORpcReader* map(unsigned long);
    boolean execute(TIORpcReader*, TIORpcHdr&);
    virtual void connectionClosed(const TransparentIO*) = 0;
protected:
   typedef void (*PF)(TIORpcReader*, TIORpcHdr&, TIOrpcstream&);
   int _nfcns;			/* size of function array */
   PF* _function;		/* function array indexed by request number */
   TIOrpcstream* _client;		/* source of RPC requests coming from client */
   TransparentIOPtr tio_ ;
private:
   /* deny access since unimplemented and member-wise won't work */
   TIORpcReader(const TIORpcReader&) {};
   TIORpcReader& operator=(const TIORpcReader&) { return *this; }
};

inline TIOrpcstream& TIORpcReader::client() {
    return *_client;
}

#endif
