// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1996
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        tiorpcstream.h
// 
// Purpose:     
// 
// Created:     20 Feb 1997   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: a copy of rpcstream.h
// 
// $Id: tiorpcstream.h,v 1.1 1997/02/20 19:32:25 jfasch Exp $
// 
// $Log: tiorpcstream.h,v $
// Revision 1.1  1997/02/20 19:32:25  jfasch
// Initial revision
//
// 
// </file> 
#ifndef hg_dispatch_tiorpcstream_h
#define hg_dispatch_tiorpcstream_h

#include "libdispatch.h"

#include "tiorpcbuf.h"

// Modify iostreamb to store a rpcbuf and provide operations on the
// rpcbuf, therefore specializing iostreamb to RPC requests.

class TIOrpcstream : public virtual iostreamb {
public:
   TIOrpcstream();
   ~TIOrpcstream();
   
   void attach (const TransparentIOPtr&);
   void close();

   TIOrpcbuf* rdbuf();
   boolean incomplete_request();
   void incomplete_request(boolean);

protected:
   void verify(int);
protected:
   TIOrpcbuf _buf;		 // streambuf specialized to RPC requests
   boolean _incomplete_request; // is the incoming request still incomplete?
};

// Return or set protected member variables.

inline TIOrpcbuf* TIOrpcstream::rdbuf() {
    return &_buf;
}

inline boolean TIOrpcstream::incomplete_request() {
    return _incomplete_request;
}

inline void TIOrpcstream::incomplete_request(boolean incomplete_request) {
    _incomplete_request = incomplete_request;
}

#endif
