/*
 * Copyright (c) 1991 Stanford University
 * Copyright (c) 1991 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Stanford and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Stanford and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */

/*
 * InputHandler - glyph that handles input
 */

/*
 * $Id: input.h,v 1.4 1996/04/24 15:33:49 bmarsch Exp $
 *
 * $Log: input.h,v $
 * Revision 1.4  1996/04/24 15:33:49  bmarsch
 * InputHandlers may be disabled
 *
 * Revision 1.3  1996/02/15 17:17:43  bmarsch
 * Includes from Dispatch/ were moved to hyperg/Dispatch/
 *
 * Revision 1.2  1996/01/22 12:48:39  bmarsch
 * Made member variables needed for help window private
 * New member function unmap_help_window()
 *
 */

#ifndef iv_input_h
#define iv_input_h

#include <InterViews/monoglyph.h>

class Color;
class Event;
class Handler;
class InputHandlerImpl;
class Style;
class Transformer;

// <begin> Peter Kogler (7.9.1995): use windows to describe the
//                                  function of the active handler
//                                  (for example buttons!) if mouse stays
//                                  a while on the active handler
class Window;
class HelpWindowAction;
#include <hyperg/Dispatch/iocallback.h>    // for timer

// <end>

class InputHandler : public MonoGlyph {
public:
    InputHandler(Glyph*, Style*);
    virtual ~InputHandler();

    virtual Handler* handler() const;
    virtual InputHandler* parent() const;
    virtual Style* style() const;

    virtual void append_input_handler(InputHandler*);
    virtual void remove_input_handler(GlyphIndex);
    virtual void remove_all_input_handlers();
    virtual GlyphIndex input_handler_count() const;
    virtual InputHandler* input_handler(GlyphIndex) const;

    virtual void focus(InputHandler*);
    virtual void next_focus();
    virtual void prev_focus();

    virtual void allocate(Canvas*, const Allocation&, Extension&);
    virtual void draw(Canvas*, const Allocation&) const;
    virtual void pick(Canvas*, const Allocation&, int depth, Hit&);
    virtual void undraw();

    virtual void move(const Event&);
    virtual void press(const Event&);
    virtual void drag(const Event&);
    virtual void release(const Event&);
    virtual void keystroke(const Event&);
    virtual void double_click(const Event&);

    virtual InputHandler* focus_in();
    virtual void focus_out();

    virtual void allocation_changed(Canvas*, const Allocation&);
    virtual boolean inside(const Event&);

    virtual Canvas* canvas() const;
    virtual const Transformer& transformer() const;
    virtual const Allocation& allocation() const;

    virtual void redraw() const;
    virtual void repick(int depth, Hit&);

    // bmarsch/jschipf: 24 Apr 96
    virtual void enable();
    virtual void disable();
    boolean is_enabled() const;

// bmarsch 951006: access functions to InputHandlerImpl
protected:
    InputHandler* focus_handler() const;
    boolean focus_handling() const;
    void check_enabled();

private:
    friend class InputHandlerImpl;

    InputHandlerImpl* impl_;
    const Color* disable_color_;
};

class ActiveHandler : public InputHandler {
protected:
    ActiveHandler(Glyph*, Style*);
public:
    virtual ~ActiveHandler();

    virtual void undraw();

    virtual void move(const Event&);
    virtual void drag(const Event&);
    virtual void enter();
    virtual void leave();

// <begin> Peter Kogler (7.9.1995): use windows to describe the
//                                  function of the active handler
//                                  (for example buttons!) if mouse stays
//                                  a while on the active handler
    virtual void show_window(long,long);
    virtual void set_help_window_action(HelpWindowAction*);
    void set_help_delay(int delay){help_delay_=delay;}
    int get_help_delay()const {return help_delay_;}

protected:
    void unmap_help_window();

private:
    Window* window_;
    HelpWindowAction* help_window_action_;
    IOHandler* help_delay_handler_;
    int help_delay_;
// <end>
    
    boolean inside_;
};


// <begin> Peter Kogler (7.9.1995): use windows to describe the
//                                  function of the active handler
//                                  (for example buttons!) if mouse stays
//                                  a while on the active handler
declareIOCallback(ActiveHandler)
// <end>

#endif
