/* NCSA CCI for X Windows
** Software Development Group
** National Center for Supercomputing Applications
** University of Illinois at Urbana-Champaign
** 605 E. Springfield, Champaign, IL 61820
** mosaic@ncsa.uiuc.edu

** Copyright  (C)  1995 Board of Trustees of the University of Illinois
*/

#ifndef cci_caller_h
#define cci_caller_h

#include <hyperg/OS/enter-scope.h>
#include <hyperg/utils/str.h>
#include <hyperg/hyperg/language.h>

extern "C" {
#include "CCI/cci.h"
}

class WFileChooser;
class Window;
class CCISceneViewer;

class CCICaller {
 protected:
  enum annotation_types {PRIVATE_ANNOTATION, 
			 GROUP_ANNOTATION, 
			 PUBLIC_ANNOTATION, 
			 num_annotation_types};
  static CCICaller* me_;
  virtual void makeConnection(int portNum, const RString& hostname);
  MCCIPort mosaicPort_;
 private:
  boolean connected_;
  RString mimeType_;
  void disconnect();
  static void handleFetch(char *anchor, void *callBackData);
  static void handleLoad(char *mimeType, char *data, int length,
			 void *callBackData); 

public:
  static CCICaller* instance() {return me_;}
  boolean connect(int portnum, char* hostname);
  boolean reconnect(int portNum, const RString& hostname);
  CCICaller(const char* mimeType);
  virtual ~CCICaller();
  void notConnected();
  boolean poll();
  virtual void follow(const RString& url);
  boolean connected() const {return connected_;}
  RString matchName(const char* name) const;
  virtual boolean putAnnotation(int type, const char *annotation);
  virtual RString getAnchors(const char* name);
  void defaultPortInfo(int& portNum, RString& hostname) const;
  virtual void updateMenu() const;
  virtual void hideAnchors() const;
  virtual RString currentURL() const;
  virtual HgLanguage::Language language() const;
  virtual Window* window() const;
  virtual void handleFetch(char *anchor);
  virtual void handleLoad(char *data, int length);
};

class SceneCCICaller : public CCICaller {
  boolean wait_;
  RString lastAsked_;
  CCISceneViewer* viewer_;
 public:
  SceneCCICaller(CCISceneViewer* scene);
  virtual ~SceneCCICaller() {}
//  virtual void updateMenu() const;
  virtual void handleFetch(char *anchor);
  virtual void handleLoad(char *data, int length);
  virtual void follow(const RString& url);
  virtual RString lastAsked() const {return lastAsked_;}
};
  
#endif




