//<copyright>
//
// Copyright (c) 1994,95
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        srcanch.C
//
// Purpose:     implementation of class SourceAnchor
//
// Created:      1 Jun 94   Michael Pichler
//
// Changed:     31 Jul 95   Michael Pichler
//
// $Id: srcanch.C,v 1.3 1997/02/25 17:03:58 mpichler Exp $
//
//</file>


#include "srcanch.h"

#include <string.h>


SourceAnchor::SourceAnchor (long id, const RString& aobject, const char* groupname)
: anchorobj_ (aobject)
{
  anchorid_ = id;

  // RStrings do not differ between NULL pointers and empty strings
  if (groupname && *groupname)  // group anchor
  {
    groupname_ = new char [strlen (groupname) + 1];
    strcpy (groupname_, groupname);
  }
  else  // object anchor
    groupname_ = 0;
}


SourceAnchor::~SourceAnchor ()
{
  delete groupname_;
}
