/*
     WWW-SQL - parses HTML files and inserts information from MySQL databases
    Copyright (C) 1997  James Henstridge <james@daa.com.au>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*   func.c
 * This file contains the implementations of all the www-sql commands
 * that are database related or related to if statement handling.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "cgi.h"
#include "cmds.h"

/* expression evaluator -- defined in expr.c */
char *evalToString(int, char **);
void evalPrint(int, char **);

void cmdPrint(int argc, char *argv[]) {
  char *tmp;

  checkNumArgs(1, "print");
  tmp = substVars(argv[0]);
  fprintf(yyout, "%s", tmp);
  free(tmp);
}

void cmdEval(int argc, char *argv[]) {
  int i;
  char *tmp;

  for (i=0; i < argc; i++) {   /* perform substitutions */
    tmp = substVars(argv[i]);
    free(argv[i]);
    argv[i] = tmp;
  }

  evalPrint(argc, argv);
}

void cmdSet(int argc, char *argv[]) {
  char *tmp;

  checkNumArgs(2,"set");
  tmp = substVars(argv[1]);
  setVar(argv[0], tmp);
  free(tmp);
}

void cmdSetDefault(int argc, char *argv[]) {
  char *tmp;

  checkNumArgs(2,"setdefault");
  tmp = substVars(argv[1]);
  setDefault(argv[0], tmp);
  free(tmp);
}

void cmdSetExpr(int argc, char *argv[]) {
  char *tmp;
  int i;

  checkNumArgs(2,"setexpr");
  for (i = 1; i < argc; i++) {
    tmp = substVars(argv[i]);
    free(argv[i]);
    argv[i] = tmp;
  }
  setVar(argv[0], evalToString(argc - 1, argv + 1));
}

void cmdDumpVars(int argc, char *argv[]) {
  VAR *var;

  fprintf(yyout, "<p>\n");
  for (var = firstVar; var != NULL; var = var->next)
    fprintf(yyout, "<b>%s</b> = %s<br>\n", var->name, var->value);
  fprintf(yyout, "</p>\n");
}

/* like the W3-mSQL convert command -- not really needed, because of ?var */
void cmdConvert(int argc, char *argv[]) {
  char *tmp;
  char *sqlEscape(char *);

  checkNumArgs(1, "convert");
  tmp = valueOf(argv[0]);
  if (tmp == NULL)
    fprintf(yyout, "<b>%s: no such variable", tmp);
  else {
    tmp = sqlEscape(tmp);
    setVar(argv[0], tmp);
    free(tmp);
  }
}

commands other_funcs = {
  {"print",      cmdPrint},
  {"eval",       cmdEval},
  {"set",        cmdSet},
  {"setdefault", cmdSetDefault},
  {"setexpr",    cmdSetExpr},
  {"dumpvars",   cmdDumpVars},
  {"convert",    cmdConvert},
  {NULL, NULL}
};

