/***************************************
  $Header: /home/amb/wwwoffle/RCS/config.h 2.14 1998/02/20 20:15:42 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.1.
  Configuration file management functions.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997,98 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#ifndef CONFIG_H
#define CONFIG_H    /*+ To stop multiple inclusions. +*/

/*+ The name of the configuration file. +*/
extern char *ConfigFile;

/* StartUp section */

/*+ The port number to use for the HTTP proxy port. +*/
extern int HTTP_Port;

/*+ The port number to use for the wwwoffle port. +*/
extern int WWWOFFLE_Port;

/*+ The spool directory. +*/
extern char *SpoolDir;

/*+ The user id for wwwoffled or -1 for none. +*/
extern int WWWOFFLE_Uid;

/*+ The group id for wwwoffled or -1 for none. +*/
extern int WWWOFFLE_Gid;

/*+ Whether to use the syslog facility or not. +*/
extern int UseSyslog;

/*+ The password required for demon configuration. +*/
extern char *PassWord;

/*+ Maximum number of servers  +*/
extern int MaxServers;          /*+ in total. +*/
extern int MaxFetchServers;     /*+ for fetching. +*/

/* Options Section */

/*+ The level of error logging (see ErrorLevel in errors.h) +*/
extern int LogLevel,            /*+ in the config file for syslog and stderr. +*/
           DebugLevel;          /*+ on the command line for stderr. +*/

/*+ The option to also fetch images. +*/
extern int FetchImages;

/*+ The option to also fetch frames. +*/
extern int FetchFrames;

/*+ The number of days to display in the index of the latest pages. +*/
extern int IndexLatestDays;

/*+ The option of a tag that can be added to the bottom of the spooled pages with the date and a refresh button. +*/
extern int AddInfoRefresh;

/*+ The maximum age of a cached page to use in preference while online. +*/
extern int RequestChanged;

/*+ The option to allow or ignore the 'Pragma: no-cache' request. +*/
extern int PragmaNoCache;

/*+ The option to not make requests while offline but to return an error. +*/
extern int OfflineRequests;

/*+ The interval in days between monitoring the specified pages. +*/
extern int MonitorInterval;

/* Purge section */

/*+ If true then use modification time instead of access time. +*/
extern int PurgeUseMTime;

/*+ The default age for purging files. +*/
extern int DefaultPurgeAge;

/*+ The maximum allowed size of the cache. +*/
extern int PurgeCacheSize;


/* In config.h */

int ReadConfigFile(int fd);

/* LocalHost section */

char *GetLocalHost(int port);

/* LocalNet section */

int IsLocalNetHost(char *host);

/* AllowedConnect section */

int IsAllowedConnect(char *host);

/* DontCache section */

int IsNotCached(char *proto,char *host,char *path);

/* DontGet section */

int IsNotGot(char *proto,char *host,char *path);

/* DontGetRecursive section */

int IsNotGotRecursive(char *proto,char *host,char *path);

/* CensorHeader section */

int IsCensoredHeader(char *line);

/* FTPOptions section */

int WhatFTPUserPass(char *host,char **user,char **pass);

/* MIMETypes section */

char *WhatMIMEType(char *path);

/* Proxy section */

char *WhichProxy(char *proto,char *host);
char *WhatProxyAuth(char *proxy);

/* Mirror section */

int IsMirrored(char *proto,char *host,char **new_proto,char **new_host);
char ***ListMirrors(char *proto);

/* Purge section */

int WhatPurgeAge(char *proto,char *host);

#endif /* CONFIG_H */
