/***************************************
  $Header: /home/amb/wwwoffle/RCS/proto.c 1.7 1998/02/10 19:17:33 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.1.
  Information about the protocols that wwwoffle supports.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997,98 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/

#include <stdlib.h>

#include "misc.h"
#include "proto.h"

/* For upgrade-cache and wwwoffle we don't want to link with all
   of the different protocols so we keep them SIMPLE. */

#ifdef SIMPLE

/*+ The list of protocols. +*/
Protocol Protocols[1];

/*+ The number of protocols. +*/
int NProtocols=0;

#else

/*+ The list of protocols. +*/
Protocol Protocols[]={
 {
  Protocol_HTTP,                /* number */
  "http",                       /* name */
  80,                           /* defport */
  1,                            /* proxyable */
  HTTP_Open,                    /* open */
  HTTP_Request,                 /* request */
  HTTP_ReadHead,                /* readhead */
  HTTP_ReadBody,                /* readbody */
  HTTP_Close                    /* close */
 },
 {
  Protocol_FTP,                 /* number */
  "ftp",                        /* name */
  21,                           /* defport */
  1,                            /* proxyable */
  FTP_Open,                     /* open */
  FTP_Request,                  /* request */
  FTP_ReadHead,                 /* readhead */
  FTP_ReadBody,                 /* readbody */
  FTP_Close                     /* close */
 },
 {
  Protocol_Finger,              /* number */
  "finger",                     /* name */
  79,                           /* defport */
  0,                            /* proxyable */
  Finger_Open,                  /* open */
  Finger_Request,               /* request */
  Finger_ReadHead,              /* readhead */
  Finger_ReadBody,              /* readbody */
  Finger_Close                  /* close */
 }
};

/*+ The number of protocols. +*/
int NProtocols=sizeof(Protocols)/sizeof(Protocol);

#endif
