.\" t
.\" @(#)Zharf.1	04/07/98
.TH Zharf 1.20 "Apr 07 1998"
.UC
.SH NAME
Zharf \- the AfterStep button panel module
.SH SYNOPSIS
Zharf is spawned by AfterStep, so no command line invocation will work.

.SH DESCRIPTION
The Zharf module provides a button panel which sits on the X
terminal's root window. The user can press the buttons at any time,
and trigger invocation of a user-specified command by the window
manager. Zharf only works when AfterStep is used as the window manager.

The button panel can be of any configuration or geometry, and can have
monochrome or color icons to represent the actions which would be
invoked.

.SH INITIALIZATION
During initialization, \fIZharf\fP will search for a configuration
file which describes the button panel geometry, color, icons, and
actions. The format of 
this files will be described later. The configuration file will be the
one which AfterStep used during its initialization.

If the Zharf executable is linked to another name, ie 'ln -s
Zharf Pier', then another module called Pier can be
started, with a completely different configuration than Zharf,
simply by changing the keywords Zharf??? to Pier???. This way multiple
button-bars can be used.

.SH INVOCATION
Zharf can be invoked by inserting the line 'Module Zharf' in
a file in start/Modules.

This can be placed in a config file, if Zharf is to be spawned on a keystroke,
or bounded to a menu or mouse button to invoke it later.
AfterStep will search directory specified in the ModulePath configuration
option to attempt to locate Zharf.

.SH CONFIGURATION OPTIONS
The following options can be placed in the zharf file

.IP "*ZharfGeometry \fIgeometry\fP"
Specifies the Zharf window location and/or size. If the size is
not specified, Zharf will auto-size itself in a reasonable manner.
The geometry is a standard X11 window geometry specification.

.IP "*ZharfFont \fIfont\fP"
Specifies the font to be used for labeling the buttons.

.IP "*ZharfRows \fIrows\fP"
Specifies the number of rows of buttons to be created. If unspecified,
2 rows will be used.

.IP "*ZharfColumns \fIcolumns\fP"
Specifies the number of columns of buttons to be created. If unspecified,
the number of columns will be set to the number of buttons requested,
divided by the number of rows. If both the rows and columns are
specified, but do not specify as many buttons as are defined, then the
users columns specification will be ignored.

.IP "*ZharfFore \fIcolor\fP"
Specifies the color for button label text and monochrome icons.

.IP "*ZharfBack \fIcolor\fP"
Specifies the color for the buttons.

.IP "*Zharf\fI[(w x h)]\fP \fIlabel icon command\fP"
Specifies a window manager built-in command, as described in the AfterStep
man page, which should be executed when a button is pressed. The label
field is the text which will be written on the button. The icon field
specifies an X11 bitmap file or XPM color icon file, containing the
icon to display on the button. Zharf will search through the path
specified in the AfterStep 'base' file, in IconPath or PixmapPath configuration
items to find the icon file. If the optional \fI(w x h)\fP is specified, then
this button will be \fIw\fP times the normal button width and \fIh\fP
times the normal button height. If label is "-" then the button label
will not be displayed.

If \fIcommand\fP is an AfterStep Exec command, then the button will remain
pushed in until a window whose name or class matches the
qouted portion of the command is encountered. This is intended to
provide visual feedback to the user that the action he has requested
will be performed. If the quoted portion contains no characters, then the
button will pop out immediately.  Note that users can continue pressing the
button, and re-executing the command, even when it looks "pressed in."

A single extension to the AfterStep built-in command set is provided.
A command of the form: *Zharf junk clock.xpm Swallow "Clock"
rclock & will cause Zharf to spawn an rclock process, and capture 
the first window whose name or resource is "Clock", and display it in
the button-bar. This is handy for applications like xclock, xbiff, and
xload. Modules can be swallowed by specifying  SwallowModule instead
of just "swallow" NOTE: if you use xclock for this application, you will want
to specify xclock -padding 0. 


.SH SAMPLE CONFIGURATION
The following are excepts from a zharf file which describe Zharf
initialization commands:

.nf
.sp
##############################################################
#Definitions used by the modules
*ZharfFore Grey70
*ZharfBack Grey40

*ZharfGeometry	-5+5
*ZharfRows	1
*ZharfFont	-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*

*Zharf Resize  Resize      Resize
*Zharf Move    Move        Move
*Zharf Lower   Down        Lower
*Zharf Raise   Up          Raise
*Zharf Kill    Kill	   Destroy

*Zharf xiterm linux-penguin.xpm	Exec "xiterm" xterm -fg wheat -bg black &
*Zharf xmcd   CDrom.xpm   	Exec "xmcd" xmcd &
*Zharf xman   Bookshelf.xpm	Exec "xman" xman &
*Zharf top    cpuchip.xpm	Exec "xwpe" xwpe &
*Zharf netscape netscape.xpm	Exec "netscape" netscape &
*Zharf -      -                 SwallowModule "Pager" Pager 0
*Zharf asload -                 Swallow "asload" asload -shape -led red &

# *Zharf(4x1) - whatever SwallowModule "Pager" Pager 0 3
.sp
.fi

The last line is a little tricky - it spawns an Pager module, and
captures it to display in a quadruple width button. Since "-" is used
for the button label, the Pager will be resized to be as big as
possible within the button's borders. "-", of course, is a
non-existent icon file, and will be ignored by Zharf.

.SH AUTHORS
Guylhem AZNAR

Robert NATION

