/*
 * IceWM
 *
 * Copyright (C) 1997,1998 Marko Macek
 */

#include "icewm.h"

YToolTip::YToolTip(YWindow *aParent, Window win): YWindow(aParent, win) {
    fText = 0;
}

YToolTip::~YToolTip() {
    if (fText) {
        free(fText);
        fText = 0;
    }
}

void YToolTip::paint(Graphics &g, int /*x*/, int /*y*/, unsigned int /*width*/, unsigned int /*height*/) {
    g.setColor(toolTipBg);
    g.fillRect(0, 0, width(), height());
    g.setColor(black);
    g.drawRect(0, 0, width() - 1, height() - 1);
    if (fText) {
        int y = toolTipFont->ascent() + 2;
        g.setFont(toolTipFont);
        g.setColor(toolTipFg);
        g.drawChars(fText, 0, strlen(fText), 3, y);
    }
}

void YToolTip::setText(const char *tip) {
    if (fText) {
        free(fText);
        fText = 0;
    }
    if (tip) {
        fText = strdup(tip);
        if (fText) {
            int w = XTextWidth(toolTipFont->getFontStruct(),
                               fText, strlen(fText));
            int h = toolTipFont->ascent();

            setSize(w + 6, h + 7);
        } else {
            setSize(20, 20);
        }
    }
}

bool YToolTip::handleTimer(YTimer */*t*/) {
    display();
    return false;
}

void YToolTip::display() {
    raise();
    show();
}

void YToolTip::locate(YWindow *w, const XCrossingEvent &/*crossing*/) {
    int x, y;

    x = w->width() / 2;
    y = w->height();
    w->mapToGlobal(x, y);
    x -= width() / 2;
    if (x + width() >= app->root()->width())
        x = app->root()->width() - width();
    if (y + height() >= app->root()->height())
        y -= height() + w->height();
    if (y < 0)
        y = 0;
    if (x < 0)
        x = 0;
    setPosition(x, y);
}
