/*
	Copyright (C) 1994	Edward Der-Hua Liu, Hsin-Chu, Taiwan
*/

#include "protocol.h"
#ifndef __FreeBSD__
#include <sys/stat.h>
#endif
#include <X11/Xlib.h> 
#include <X11/Xatom.h>
#include "state.h"

Window cli_win;
extern Display *display;
extern Window main_win;
extern Atom xcin_atom;
extern void p_err(char *fmt,...);
extern void switch_active_client(InmdState *state, Window cli_win);
extern void close_xcin(Window cli_win);
extern void getch(KeySym ch, int state);
extern int puts(char *s);
extern void load_phrase(Window cli_win, u_long bytes_after);

#define ENDIAN_TEST() (*(int *)"\x11\x22\x33\x44"==0x11223344)
char my_endian;

void init_msg_channel()
{
Window twin;
xcin_atom=XInternAtom(display,XCIN_ATOM,False);
my_endian=ENDIAN_TEST();

if ((twin=XGetSelectionOwner(display,xcin_atom))!=None) {
        p_err("Xcin is already active. Win Id %x\n",twin);
}
XSetSelectionOwner(display, xcin_atom, main_win, CurrentTime);
}

int ignore_first_time=1;
#define TSIZE (256)

void message_dispatch(XClientMessageEvent *ev)
{
u_char *buf=(u_char *) &ev->data.l[0];

cli_win=ev->window;
if (ev->format==8 && buf[0]==0xff && buf[1]==0xff && buf[2]==0xff) {
	if (buf[3]==CLI_FOCUS_IN)
		switch_active_client((InmdState *)&buf[4],cli_win);
	else
		close_xcin(cli_win);
}
else
if (ev->format==32) {
#if	0
	printf("key rec %x %x\n", *(int *)buf,   *(int *)&buf[4]);
#endif	0
	getch(* (int *)buf, *((int *)&buf[4]));
}
else
  puts("error");
}

void property_dispatch(XPropertyEvent *ev)
{
        Atom actual_type;
        int actual_format;
        u_long nitems,bytes_after;
	int *cmd,cm;
	Window cli_win=ev->window;
	
	if (ev->state==PropertyDelete || cli_win==main_win) return;
 
	if (XGetWindowProperty(display,cli_win,xcin_atom, 0, 1,
		True, AnyPropertyType, &actual_type,&actual_format,
		&nitems,&bytes_after,(unsigned char **)&cmd) != Success)
		puts("err prop");
	if (nitems==0) return;
	cm=*cmd;
	XFree(cmd);
	if (cm==LOAD_KEYWORD) {
		load_phrase(cli_win, bytes_after);
	} else {
		puts("Unknown property");
	}
}


void big_little(char *i)
{
char t;
t=*i; *i=*(i+3); *(i+3)=t;
t=*(i+1); *(i+1)=*(i+2); *(i+2)=t;
}


void write_reply(char *str, int len, int status)
{
	extern InmdState inmdstate;
	int slen;
	XCIN_RES res;

	res.len=len;
	res.status=status;
	res.inmdstate=inmdstate;
	if (my_endian) {  /* the format is convert to little-endian */ 
		big_little((char *)&res.len);
		big_little((char *)&res.status);
	}
	memcpy(res.tkey, str, len);
	slen=sizeof(res)-sizeof(res.tkey)+len;

	XChangeProperty(display, main_win , xcin_atom, XA_STRING, 8,
		PropModeReplace, (u_char *)&res, slen);
	XSync(display,False);
}
