/* xkeycaps, Copyright (c) 1991, 1992, 1993 Jamie Zawinski <jwz@netscape.com>
 *
 * This file describes the default keymap of the HP PC keyboard.
 * By Markus Stumpf <stumpf@informatik.tu-muenchen.de>
 */

#ifndef  hpXK_BackTab
# define hpXK_BackTab		0x1000FF74
#endif

static const struct default_keycode_map hppc_map [] = {
  {   8, ControlMask,	{ XK_Control_R }},
  {  10, Mod1Mask,	{ XK_Alt_R }},
  {  11, Mod1Mask,	{ XK_Alt_L }},
  {  12, ShiftMask,	{ XK_Shift_R }},
  {  13, ShiftMask,	{ XK_Shift_L }},
  {  14, ControlMask,	{ XK_Control_L }},
  {  15, 0,		{ XK_Pause,	XK_Break }},
  {  16, 0,		{ XK_KP_4,	XK_Left }},
  {  17, 0,		{ XK_KP_8,	XK_Up }},
  {  18, 0,		{ XK_KP_5 }},
  {  19, 0,		{ XK_KP_9,	XK_Prior }},
  {  20, 0,		{ XK_KP_6,	XK_Right }},
  {  21, 0,		{ XK_KP_7,	XK_Home }},
  {  23, 0,		{ XK_KP_Enter }},
  {  24, 0,		{ XK_KP_1,	XK_End }},
  {  25, 0,		{ XK_KP_Divide }},
  {  26, 0,		{ XK_KP_2,	XK_Down }},
  {  27, 0,		{ XK_KP_Add }},
  {  28, 0,		{ XK_KP_3,	XK_Next }},
  {  29, 0,		{ XK_KP_Multiply }},
  {  30, 0,		{ XK_KP_0,	XK_Insert }},
  {  31, 0,		{ XK_KP_Subtract }},
  {  32, 0,		{ XK_B }},
  {  33, 0,		{ XK_V }},
  {  34, 0,		{ XK_C }},
  {  35, 0,		{ XK_X }},
  {  36, 0,		{ XK_Z }},
  {  39, 0,		{ XK_Escape,	XK_Delete }},
  {  41, 0,		{ XK_F10,	XK_KP_F2 }},
  {  43, 0,		{ XK_F11,	XK_KP_F3 }},
  {  44, 0,		{ XK_KP_Decimal,	XK_Delete }},
  {  45, 0,		{ XK_F9,	XK_KP_F1 }},
  {  47, 0,		{ XK_F12,	XK_KP_F4 }},
  {  48, 0,		{ XK_H }},
  {  49, 0,		{ XK_G }},
  {  50, 0,		{ XK_F }},
  {  51, 0,		{ XK_D }},
  {  52, 0,		{ XK_S }},
  {  53, 0,		{ XK_A }},
  {  55, LockMask,	{ XK_Caps_Lock }},
  {  56, 0,		{ XK_U }},
  {  57, 0,		{ XK_Y }},
  {  58, 0,		{ XK_T }},
  {  59, 0,		{ XK_R }},
  {  60, 0,		{ XK_E }},
  {  61, 0,		{ XK_W }},
  {  62, 0,		{ XK_Q }},
  {  63, 0,		{ XK_Tab,	hpXK_BackTab }},
  {  64, 0,		{ XK_7,	XK_ampersand }},
  {  65, 0,		{ XK_6,	XK_asciicircum }},
  {  66, 0,		{ XK_5,	XK_percent }},
  {  67, 0,		{ XK_4,	XK_dollar }},
  {  68, 0,		{ XK_3,	XK_numbersign }},
  {  69, 0,		{ XK_2,	XK_at }},
  {  70, 0,		{ XK_1,	XK_exclam }},
  {  71, 0,		{ XK_grave,	XK_asciitilde }},
  {  80, 0,		{ XK_Print }},
  {  81, 0,		{ XK_F4 }},
  {  82, 0,		{ XK_F3 }},
  {  83, 0,		{ XK_F2 }},
  {  84, 0,		{ XK_F1 }},
  {  86, 0,		{ XK_Scroll_Lock }},
  {  88, Mod5Mask,	{ XK_Num_Lock,	XK_Num_Lock }},
  {  89, 0,		{ XK_F5 }},
  {  90, 0,		{ XK_F6 }},
  {  91, 0,		{ XK_F7 }},
  {  92, 0,		{ XK_F8 }},
  {  96, 0,		{ XK_8,	XK_asterisk }},
  {  97, 0,		{ XK_9,	XK_parenleft }},
  {  98, 0,		{ XK_0,	XK_parenright }},
  {  99, 0,		{ XK_minus,	XK_underscore }},
  { 100, 0,		{ XK_equal,	XK_plus }},
  { 101, 0,		{ XK_BackSpace }},
  { 104, 0,		{ XK_I }},
  { 105, 0,		{ XK_O }},
  { 106, 0,		{ XK_P }},
  { 107, 0,		{ XK_bracketleft,	XK_braceleft }},
  { 108, 0,		{ XK_bracketright,	XK_braceright }},
  { 109, 0,		{ XK_backslash,	XK_bar }},
  { 110, 0,		{ XK_Insert }},
  { 111, 0,		{ XK_Delete }},
  { 112, 0,		{ XK_J }},
  { 113, 0,		{ XK_K }},
  { 114, 0,		{ XK_L }},
  { 115, 0,		{ XK_semicolon,	XK_colon }},
  { 116, 0,		{ XK_apostrophe,	XK_quotedbl }},
  { 117, 0,		{ XK_Return }},
  { 118, 0,		{ XK_Home }},
  { 119, 0,		{ XK_Prior }},
  { 120, 0,		{ XK_M }},
  { 121, 0,		{ XK_comma,	XK_less }},
  { 122, 0,		{ XK_period,	XK_greater }},
  { 123, 0,		{ XK_slash,	XK_question }},
  { 125, 0,		{ XK_End }},
  { 127, 0,		{ XK_Next }},
  { 128, 0,		{ XK_N }},
  { 129, 0,		{ XK_space }},
  { 132, 0,		{ XK_Left }},
  { 133, 0,		{ XK_Down }},
  { 134, 0,		{ XK_Up }},
  { 135, 0,		{ XK_Right }}
  };
