/* xkeycaps, Copyright (c) 1991, 1992, 1993 Jamie Zawinski <jwz@netscape.com>
 *
 * This file describes the german Apple Extended II Keyboard for use with
 * MkLinux.
 *
 * By Albrecht Dre <dress@tee.uni-essen.de>, derived from the file 
 * `mac-caps.h' by John Knox <johnx@exlog.com> and Chris Jones, Baker Hughes
 * Inteq DEAP Support, Aberdeen.
 *
 * Copyright (C) by Albrecht Dress 1997. This file is "really free" under the
 * terms the standard X license/copyright.
 */

static const struct key_strings mac_mklinux_de_caps [] = {

  /* Row 0 */

  {"Esc", 0},
  {"F1", 0},
  {"F2", 0},
  {"F3", 0},
  {"F4", 0},
  {"F5", 0},
  {"F6", 0},
  {"F7", 0},
  {"F8", 0},
  {"F9", 0},
  {"F10", 0},
  {"F11", 0},
  {"F12", 0},
  {"Druck", "F13", 0},
  {"Syst.Anfr.", "F14", 0},
  {"Pause", "F15", 0},

  /* Row 2 */

  {"", "^", 0},
  {"!", "1", 0},
  {"\"", "2", 0},
  {"", "3", 0},
  {"$", "4", 0},
  {"%", "5", 0},
  {"&", "6", 0},
  {"/", "7", 0},
  {"(", "8", 0},
  {")", "9", 0},
  {"=", "0", 0},
  {"?", "", 0},
  {"`", "'", 0},
  {"<----", 0},
  {"Einf.", "Hilfe", 0},
  {"Anfg", 0},
  {"SeiteO", 0},
  {"Num ", "Lock", 0},
  {"=", 0},
  {"/", 0},
  {"*", 0},

  /* Row 3 */

  {"-->|", 0},
  {"Q", 0},
  {"W", 0},
  {"E", 0},
  {"R", 0},
  {"T", 0},
  {"Z", 0},
  {"U", 0},
  {"I", 0},
  {"O", 0},
  {"P", 0},
  {"", 0},
  {"*", "+", 0},
  {"Return", 0},
  {"Entf.", 0},
  {"Ende", 0},
  {"SeiteU", 0},
  {"7", 0},
  {"8", 0},
  {"9", 0},
  {"-", 0},

  /* Row 4 */

  {"Caps", "lock", 0},
  {"A", 0},
  {"S", 0},
  {"D", 0},
  {"F", 0},
  {"G", 0},
  {"H", 0},
  {"J", 0},
  {"K", 0},
  {"L", 0},
  {"", 0},
  {"", "'", 0},
  {"'", "#", 0},
  {"4", 0},
  {"5", 0},
  {"6", 0},
  {"+", 0},

  /* Row 5 */

  {"Shift", 0},
  {">", "<", 0},
  {"Y", 0},
  {"X", 0},
  {"C", 0},
  {"V", 0},
  {"B", 0},
  {"N", 0},
  {"M", 0},
  {";", ",", 0},
  {":", ".", 0},
  {"_", "-", 0},
  {"Shift", 0},
  {"UpArrow", 0},
  {"1", 0},
  {"2", 0},
  {"3", 0},
  {"Enter", 0},

  /* Row 6 */

  {"Ctrl", 0},
  {"alt", 0},
  {"%", 0},	/* that silly clover symbol */
  {" ", 0},
  {"%", 0},	/* that silly clover symbol */
  {"alt gr", 0},
  {"Ctrl", 0},
  {"LeftArrow", 0},
  {"DownArrow", 0},
  {"RightArrow", 0},
  {"0", 0},
  {".", 0}
};
