static char qconf_rcsid[]="$Id: qconf.c,v 1.1.1.1 1997/04/10 15:10:35 green Exp $";

/*----------------------------------------------------
 * qconf.c Tom Green Mon Jan 31 10:43:11 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: qconf.c,v $
 * Revision 1.1.1.1  1997/04/10 15:10:35  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.3  1996/11/20 23:05:09  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.2  1994/06/12  03:45:29  green
 * mods to dqs_send_receive_list() necessitated for the support of
 * moving dshd into dqs_execd required propagation to all ancillaries.
 * (eg: return value of dqs_send_receive_list() was modified...)
 *
 * Revision 3.1  1994/03/26  16:33:39  green
 * added "-srl" support.
 *
 * dqs_resolve.c:dqs_read_resolve_file() now returns the primary qmaster
 * name for fields marked as "none"
 *
 * Revision 3.0  1994/03/07  04:15:15  green
 * 3.0 freeze
 *
 * Revision 1.2  1994/03/04  20:07:48  green
 * modified dqs_showlist() to handle NULLs - more gracefully.
 *
 * added a warning for "unknown" requests in dqs_parse.c - this should
 * probably be an exit - but as the code is being relased in 2 days,
 * scared I might break more than I fix....
 *
 * fixed qconf so it no longer drops core if no options.
 *
 * Revision 1.1.1.1  1994/02/01  17:57:50  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/

 
#define MAINPROGRAM
#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

/************************************************************************/

main(argc, argv,envp)
int argc;
char **argv;
char **envp;

{

     dqs_list_type    *argv_list=(dqs_list_type *) NULL;
     dqs_list_type    *req=(dqs_list_type *) NULL;
     dqs_list_type    *resp=(dqs_list_type *) NULL;
     
     DENTER_MAIN((DQS_EVENT,"qconf"));   
     
     dqs_setup(QCONF,argv[0]);
     dqs_setup_sig_handlers();     

     if (argc==1)
     {
	  dqs_usage();
	  DEXITE;
	  exit(-1);
     }

     argv_list=dqs_args2list(++argv,argc);
     req=dqs_parse_qconf(argv_list,envp);

     if (!req) 
     {
	  DPRINTF((DQS_EVENT,"dqs_parse_qconf() returned NULL"));
	  exit(0);
	  
     }

     if (dqs_send_receive_list(me.default_cell,conf.qmaster_service,req,&resp)<0)
     {
	  DEXITE;
	  exit(DQS_EAGAIN);
     }

     dqs_show_acknak_list(resp);

     DEXIT;
     exit(resp->int0);
     
} 

