;;; dload.scm 
;;; (c) Alexandre Frey 1996
(module dload
	(import ident)
	(include "dloadlib.inc")
	(export 
	 *default-lib*
	 *static-unit*
	 (inline unit? o)
	 (dload-init map-filename)
	 (inline make-empty-unit)
	 (inline unit-closed? unit)
	 (dload unit filename . use_static?)
	 (get-symbol-value unit module-name var-name)
	 (set-symbol-value! unit module-name var-name value)
	 (module-initialize unit module-name)
	 (unit-undefined-symbols unit)

	 (undefined-walker string));; needed for awful hackerish reasons
	(foreign
	 (type unit (pointer foreign))
	 (void gc-gcollect () "GC_gcollect")
	 
	 (void c-dload-init (string) "dload_init")
	 (unit c-static-unit "static_dlink_info")
	 (obj c-make-empty-unit () "make_unit")
	 (bool dlink-closed? (unit) "dlink_info_closed_p")
	 (bool dlink-add-file (unit string bool) "dlink_add_file")
	 (bool dlink-link (unit) "dlink_info_link")
	 (bool dlink-symbol-defined? (unit string) 
	       "dlink_info_symbol_defined_p")
	 (obj c-get-symbol-value (unit string) "get_symbol_value")
	 (void c-set-symbol-value (unit string obj) "set_symbol_value")
	 (obj c-call-initialisation-function (unit string)
	      "call_initialisation_function") 
	 (void walk-on-undefined (unit)
	       "walk_on_undefined")
	 (int file-mtime-compare (string string) "file_mtime_compare")
	 
	 (export obj notify-error (string string string) "notify_error") 
	 
	 ;;; called by walk_on_undefined
	 (export obj undefined-walker (string) "undefined_walker")))

(define *static-unit* c-static-unit)

(define-inline (gc)
  (gc-gcollect) )

(define (dload-init map-filename)
  (if (> (file-mtime-compare *exec-filename* map-filename) 0)
      (notify-error 'unit-warning "Map file older than executable" 
		    `(,*exec-filename* ,map-filename) ) )
  (c-dload-init map-filename) )

(define-inline (make-empty-unit) 
  (c-make-empty-unit))

(define-inline (unit-closed? unit) (dlink-closed? unit))

(define (close-with-default-libraries! unit)
  (for-each
   (lambda (library)
     (dlink-add-file unit library #t) )
   *default-lib*) )

;;; dynamically load the file FILENAME
;;; by default use_static? is false
(define (dload unit filename . use_static?)
  (let ((use_static? (if (null? use_static?)
			 #f
			 (car use_static?) ) ))
    (dlink-add-file unit filename use_static?)
    (close-with-default-libraries! unit)
    (if (unit-closed? unit)
	(dlink-link unit)
	#f) ) )

(define (cid module name test)
  ;; the identifier may be a function or just an object
  (let* ((name (symbol->string name))
	 (module (symbol->string module)) 
	 (closure-name (scheme-id->c-id (string-append name "_ENV@" module))) )
    (if (test closure-name)
	;; so it's a function name
	closure-name
	;; it's just an ordinary object
	(scheme-id->c-id (string-append name "@" module)) ) ) )

(define (get-symbol-value unit module-name var-name)
  (c-get-symbol-value 
   unit
   (cid  module-name var-name (lambda (s) (dlink-symbol-defined? unit s))) ) )

(define (set-symbol-value! unit module-name var-name value)
  (c-set-symbol-value 
   unit
   (cid module-name var-name (lambda (s) 
			       (if (dlink-symbol-defined? unit s)
				   (error "UNIT-ERROR" "Assignment on functionnal value" s)
				   #f) ) )
   value) )


(define (module-initialize unit module-name)
  (c-call-initialisation-function
   unit
   (scheme-id->c-id
    (string-append
     (symbol->string module-name)
     "-INITIALISATION@"
     (symbol->string module-name) ) ) ) )

;;; Perhaps this peace of hack is no longer necessary
;;; in bigloo 1.8 ...
(define undefined-list '())

(define (undefined-walker string)
  (set! undefined-list (cons string undefined-list)) )

(define (unit-undefined-symbols unit)
  (set! undefined-list '())
  (walk-on-undefined unit)
  undefined-list)

(define *exec-filename* (string-append (getenv "PWD") 
				       "/" 
				       (car (command-line))))

;;; EOF : dload.scm


