;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Expand/define.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec 28 15:56:53 1994                          */
;*    Last change :  Tue Jun 10 13:22:52 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `define' forms                                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module expand_define
   (include "Expand/expander.sch"
	    "Tools/trace.sch")
   (import  tools_progn
	    tools_args
	    tools_error
	    tools_speek
	    tools_misc
	    expand_expander
	    expand_eps
	    expand_lambda
	    engine_param
	    type_type
	    ast_ident)
   (export  (expand-define  ::obj ::procedure)
	    (expand-method  ::obj ::procedure)
	    (expand-inline  ::obj ::procedure)
	    (expand-generic ::obj ::procedure)
	    (expand-set!    ::obj ::procedure)))

;*---------------------------------------------------------------------*/
;*    expand-define ...                                                */
;*    -------------------------------------------------------------    */
;*    on divise en deux sous:                                          */
;*       1- on define une lambda.                                      */
;*       2- on define une valeur (autre qu'un lambda).                 */
;*---------------------------------------------------------------------*/
(define (expand-define x e)
   (trace expand "expand-define: " x
	  " " (if internal-definition? "[internal]" "[external]")
	  #\Newline)
   (if internal-definition?
       (expand-internal-define x e)
       (expand-external-define x e)))

;*---------------------------------------------------------------------*/
;*    expand-external-define ...                                       */
;*---------------------------------------------------------------------*/
(define (expand-external-define x e)
   (set! internal-definition? #t)
   (let ((res (match-case x
		 ;; 1- on definit une lambda 
		 ((or (?- ((and (? symbol?) ?name) . ?args) .
			  (and ?body (not ())))
		      (?- (and (? symbol?) ?name)
			  (lambda ?args . (and ?body (not ())))))
		  (do-external-define-lambda e name args body))
		 ;; 3- on definit une valeur non typee
		 ((?-  (and (? symbol?) ?name). (and ?value (not ())))
		  (do-external-define-value e name value))
		 ;; 3b- on definit une valeur typee
		 (else
		  (error #f "Illegal `define' form" x)))))
      (set! internal-definition? #f)
      (replace! x res)))

;*---------------------------------------------------------------------*/
;*    expand-internal-define ...                                       */
;*---------------------------------------------------------------------*/
(define (expand-internal-define x e)
   (let ((e (internal-begin-expander e)))
      (match-case x
	 ;; 1- (define (foo ..) ...) form
	 ((?- (?name . ?args) . (and ?body (not ())))
	  (if (not (symbol? name))
	      (error "define" "Illegal `define' form" x)
	      (let* ((pid     (parse-id name))
		     (name-id (car pid))
		     (type-id (type-id (cdr pid))))
		 (with-lexical
		  (args*->args-list args)
		  '_
		  (lambda ()
		     (replace! x
			       `(define ,name-id
				   (,(symbol-append 'lambda 4dots type-id)
				    ,args
				    ,(e (normalize-progn body) e)))))))))
	 ;; 1b- (define foo (lambda ...)) form
	 ((?- (and (? symbol?) ?name)
	      (and ?value (?lam ?args . (and ?body (not ())))))
	  (if (eq? (fast-id-of-id lam) 'lambda)
	      (if (not (symbol? name))
		  (error "define" "Illegal `define' form" x)
		  (let* ((pid     (parse-id name))
			 (name-id (car pid))
			 (type-id (type-id (cdr pid))))
		     (with-lexical
		      (args*->args-list args)
		      '_
		      (lambda ()
			 (replace! x
				   `(define ,name-id
				       (,(symbol-append 'lambda 4dots type-id)
					,args
					,(e (normalize-progn body) e))))))))
	      (replace! x `(define ,name ,(e value e)))))
	 ;; 2- a value binding
	 ((?- (and (? symbol?) ?name) . (and ?value (not ())))
	  (replace! x `(define ,name ,(e (normalize-progn value) e))))
	 (else
	  (error #f "Illegal `define' form" x)))))

;*---------------------------------------------------------------------*/
;*    expand-set! ...                                                  */
;*---------------------------------------------------------------------*/
(define (expand-set! x e)
   (define (internal-expand-set! x e)
      (match-case x
	 ((?- (and (? symbol?) ?var) ?value)
	  ;; on test si la variable est liee quelque part
	  (enter-function var)
	  (let ((ev (e value e)))
	     (leave-function)
	     (replace! x `(set! ,var ,ev))))
	 ((?- (and (@ (and ?id (? symbol?)) (? symbol?)) ?var) ?value)
	  ;; on test si la variable est liee quelque part
	  (enter-function id)
	  (let ((ev (e value e)))
	     (leave-function)
	     (replace! x `(set! ,var ,ev))))
	 (else
	  (error #f "Illegal `set!' form" x))))
   (if internal-definition?
       (internal-expand-set! x e)
       (begin
	  (set! internal-definition? #t)
	  (let ((res (internal-expand-set! x (internal-begin-expander e))))
	     (set! internal-definition? #f)
	     (replace! x res)))))

;*---------------------------------------------------------------------*/
;*    expand-method ...                                                */
;*---------------------------------------------------------------------*/
(define (expand-method x e)
   (match-case x
      ((?kw ((and (? symbol?) ?id) . ?args) . (and ?body (not ())))
       (with-lexical
	(args*->args-list args)
	'_
	(lambda ()
	   (replace! x (do-inline/generic/method kw e id id args body)))))
      (else 
       (error #f
	      (string-append "Illegal `define-method' form")
	      x))))

;*---------------------------------------------------------------------*/
;*    expand-inline ...                                                */
;*---------------------------------------------------------------------*/
(define (expand-inline x e)
   (match-case x
      ((?kw ((and ?id (or (and (? symbol?) ?name)
			  (@ (and (? symbol?) ?name) (? symbol?)))) . ?args)
	    . (and ?body (not ())))
       (with-lexical
	(args*->args-list args)
	'_
	(lambda ()
	   (replace! x (do-inline/generic/method kw e id name args body)))))
      (else
       (error #f
	      (string-append "Illegal `define-inline' form")
	      x))))

;*---------------------------------------------------------------------*/
;*    expand-generic ...                                               */
;*---------------------------------------------------------------------*/
(define (expand-generic x e)
   (match-case x
      ((?kw ((and ?id (or (and (? symbol?) ?name)
			  (@ (and (? symbol?) ?name) (? symbol?)))) . ?args)
	    . ?body)
       (with-lexical
	(args*->args-list args)
	'_
	(lambda ()
	   (replace! x (do-inline/generic/method kw e id name args body)))))
      (else
       (error #f "Illegal `define-generic' form" x))))

;*---------------------------------------------------------------------*/
;*    do-external-define-lambda ...                                    */
;*---------------------------------------------------------------------*/
(define (do-external-define-lambda e name::symbol args body)
   (enter-function name)
   (let* ((symbol name)
	  (O-exp  (find-O-expander symbol))
	  (e      (internal-begin-expander e)))
      ;; est-ce qu'on n'est pas en train de redefinir une fonction
      ;; librairie qui, pour etre optimisee, etait aussi une macro ?
      (if (and (expander? O-exp) (not *lib-mode*))
	  (begin
	     (warning "top-level" "Redefinition of library function -- " name)
	     (unbind-O-expander! symbol)))
      (let ((ebody  (with-lexical
		     (args*->args-list args)
		     '_
		     (lambda () (e (normalize-progn body) e)))))
	 (leave-function)
	 `(define ,(cons name args) ,ebody))))

;*---------------------------------------------------------------------*/
;*    do-external-define-value ...                                     */
;*---------------------------------------------------------------------*/
(define (do-external-define-value e name value)
   (let* ((symbol name)
	  (O-exp  (find-O-expander symbol))
	  (e      (internal-begin-expander e)))
      ;; est-ce qu'on n'est pas en train de redefinir une fonction
      ;; librairie qui, pour etre optimisee, etait aussi une macro ?
      (if (and (expander? O-exp) (not *lib-mode*))
	  (begin
	     (warning "Redefinition of library function -- " name)
	     (unbind-O-expander! symbol)))
      (let ((evalue (e (normalize-progn value) e)))
	 `(define ,name ,evalue))))

;*---------------------------------------------------------------------*/
;*    do-inline/generic/method ...                                     */
;*---------------------------------------------------------------------*/
(define (do-inline/generic/method define-keyword e id name args body)
   (set! internal-definition? #t)
   (enter-function name)
   (let* ((O-exp  (find-O-expander name))
	  (e      (internal-begin-expander e))
	  (ebody  (if (pair? body)
		      (with-lexical
		       (args*->args-list args)
		       '_
		       (lambda ()
			  (e (normalize-progn body) e)))
		      '())))
      (leave-function)
      ;; est-ce qu'on n'est pas en train de redefinir une fonction
      ;; librairie qui, pour etre optimisee, etait aussi une macro ?
      (if (and (expander? O-exp) (not *lib-mode*))
	  (begin
	     (warning "Redefinition of library function -- " name)
	     (unbind-O-expander! name)))
      (set! internal-definition? #f)
      (if (null? ebody)
	  `(,define-keyword ,(cons id args))
	  `(,define-keyword ,(cons id args) ,ebody))))

