/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*            Xavier Leroy, projet Cristal, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 1996 Institut National de Recherche en Informatique et   */
/*  Automatique.  Distributed only by permission.                      */
/*                                                                     */
/***********************************************************************/

/* $Id: chmod.c,v 1.4 1996/09/04 14:14:21 xleroy Exp $ */

#include <mlvalues.h>
#include "unixsupport.h"

value unix_chmod(path, perm)     /* ML */
     value path, perm;
{
  int ret;
  ret = chmod(String_val(path), Int_val(perm));
  if (ret == -1) uerror("chmod", path);
  return Val_unit;
}
