/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.x3p;

import java.util.Hashtable;

public class StreamFormat {
    static final short DOC_TYPE_UNKOWN = 0;
    static final short DOC_TYPE_XML = 1;
    static final short DOC_TYPE_HTML = 2;
    static final short DOC_TYPE_XHTML = 3;
    static final short DOC_TYPE_DTD = 4;
    static final short DEFAULT_LINE_WRAP = 72;
    static final short DEFAULT_INDENT_SPACES = 4;
    public static final StreamFormat XML = new StreamFormat(1);
    public static final StreamFormat XML_COMPACT = new StreamFormat(XML).changeToCompact();
    public static final StreamFormat XML_PRETTY = new StreamFormat(XML).changeToPretty();
    public static final StreamFormat HTML = new StreamFormat(2);
    public static final StreamFormat HTML_COMPACT = new StreamFormat(HTML).changeToCompact();
    public static final StreamFormat HTML_PRETTY = new StreamFormat(HTML).changeToPretty();
    public static final StreamFormat XHTML = new StreamFormat(3);
    public static final StreamFormat XHTML_COMPACT = new StreamFormat(XHTML).changeToCompact();
    public static final StreamFormat XHTML_PRETTY = new StreamFormat(XHTML).changeToPretty();
    private boolean _pretty = false;
    private boolean _compact = false;
    private boolean _standalone = false;
    private String _lineSeparator;
    private short _indentSpaces = (short)4;
    private short _lineWrap = (short)72;
    private short _docType = 0;
    private String _encoding = "UTF8";
    private String _publicId;
    private String _systemId;
    private String _internalDTD;
    private static Hashtable _cache = new Hashtable();

    StreamFormat(StreamFormat streamFormat) {
        this._pretty = streamFormat._pretty;
        this._compact = streamFormat._compact;
        this._standalone = streamFormat._standalone;
        this._lineSeparator = streamFormat._lineSeparator;
        this._indentSpaces = streamFormat._indentSpaces;
        this._lineWrap = streamFormat._lineWrap;
        this._docType = streamFormat._docType;
        this._encoding = streamFormat._encoding;
        this._internalDTD = streamFormat._internalDTD;
        this._publicId = streamFormat._publicId;
        this._systemId = streamFormat._systemId;
    }

    private StreamFormat(short s) {
        this._docType = s;
    }

    public StreamFormat changeEncoding(String string) {
        if (this._encoding == string || this._encoding != null && this._encoding.equals(string)) {
            return this;
        }
        StreamFormat streamFormat = new StreamFormat(this);
        streamFormat._encoding = string;
        return streamFormat;
    }

    public StreamFormat changeExternalDTD(String string, String string2) {
        if (this._publicId == string && this._systemId == string2 || this._publicId == string && this._systemId != null && this._systemId.equals(string2) || this._publicId != null && this._publicId.equals(string) && this._systemId != null && this._systemId.equals(string2)) {
            return this;
        }
        StreamFormat streamFormat = new StreamFormat(this);
        streamFormat._publicId = string;
        streamFormat._systemId = string2;
        return streamFormat;
    }

    public StreamFormat changeIndentSpaces(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 16) {
            n = 16;
        }
        if (this._indentSpaces == n) {
            return this;
        }
        StreamFormat streamFormat = new StreamFormat(this);
        streamFormat._indentSpaces = (short)n;
        return streamFormat;
    }

    public StreamFormat changeInternalDTD(String string) {
        if (this._internalDTD == string || this._internalDTD != null && this._internalDTD.equals(string)) {
            return this;
        }
        StreamFormat streamFormat = new StreamFormat(this);
        streamFormat._internalDTD = string;
        return streamFormat;
    }

    public StreamFormat changeLineSeparator(String string) {
        if (this._lineSeparator == string || this._lineSeparator != null && this._lineSeparator.equals(string)) {
            return this;
        }
        StreamFormat streamFormat = new StreamFormat(this);
        streamFormat._lineSeparator = string;
        return streamFormat;
    }

    public StreamFormat changeLineWrap(int n) {
        if (n < 0 || n == 0) {
            n = 0;
        } else if (n < 40) {
            n = 40;
        }
        if (this._lineWrap == n) {
            return this;
        }
        StreamFormat streamFormat = new StreamFormat(this);
        streamFormat._lineWrap = (short)n;
        return streamFormat;
    }

    public StreamFormat changeStandalone(boolean bl) {
        if (this._standalone == bl) {
            return this;
        }
        StreamFormat streamFormat = new StreamFormat(this);
        streamFormat._standalone = bl;
        return streamFormat;
    }

    public StreamFormat changeToCompact() {
        if (this._compact) {
            return this;
        }
        StreamFormat streamFormat = new StreamFormat(this);
        streamFormat._compact = true;
        streamFormat._pretty = false;
        return streamFormat;
    }

    public StreamFormat changeToDefault() {
        if (!this._compact && !this._pretty) {
            return this;
        }
        StreamFormat streamFormat = new StreamFormat(this);
        streamFormat._pretty = false;
        streamFormat._compact = false;
        return streamFormat;
    }

    public StreamFormat changeToHTML() {
        if (this._docType == 2) {
            return this;
        }
        StreamFormat streamFormat = new StreamFormat(this);
        streamFormat._docType = (short)2;
        return streamFormat;
    }

    public StreamFormat changeToPretty() {
        if (this._pretty) {
            return this;
        }
        StreamFormat streamFormat = new StreamFormat(this);
        streamFormat._pretty = true;
        streamFormat._compact = false;
        return streamFormat;
    }

    public StreamFormat changeToXHTML() {
        if (this._docType == 3) {
            return this;
        }
        StreamFormat streamFormat = new StreamFormat(this);
        streamFormat._docType = (short)3;
        return streamFormat;
    }

    public StreamFormat changeToXML() {
        if (this._docType == 1) {
            return this;
        }
        StreamFormat streamFormat = new StreamFormat(this);
        streamFormat._docType = 1;
        return streamFormat;
    }

    public String getDTDPublicId() {
        return this._publicId;
    }

    public String getDTDSystemId() {
        return this._systemId;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public short getIndentSpaces() {
        return this._indentSpaces;
    }

    public String getInternalDTD() {
        return this._internalDTD;
    }

    public String getLineSeparator() {
        return this._lineSeparator;
    }

    public short getLineWrap() {
        return this._lineWrap;
    }

    public boolean isCompact() {
        return this._compact;
    }

    public boolean isDefault() {
        return !this._pretty && !this._compact;
    }

    public boolean isHTML() {
        return this._docType == 2;
    }

    public boolean isPreserveSpace() {
        return this._compact ^ true;
    }

    public boolean isPretty() {
        return this._pretty;
    }

    public boolean isStandalone() {
        return this._standalone;
    }

    public boolean isXHTML() {
        return this._docType == 3;
    }

    public boolean isXML() {
        return this._docType == 1;
    }
}

