/*
 * Decompiled with CFR 0.152.
 */
package org.openxml;

import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class XMLBookmarks {
    private static Hashtable _allBookmarks;
    private Hashtable _bookmarks;
    private Document _document;

    XMLBookmarks(Document document) {
        if (document == null) {
            throw new NullPointerException("Argument 'document' is null.");
        }
        this._document = document;
        this._bookmarks = new Hashtable();
    }

    public synchronized Element get(String string) {
        Element element = (Element)this._bookmarks.get(string);
        if (element != null && element.getOwnerDocument() != this._document) {
            this._bookmarks.remove(string);
            element = null;
        }
        return element;
    }

    public Document getDocument() {
        return this._document;
    }

    public synchronized String[] list() {
        int n = 0;
        String[] stringArray = new String[this._bookmarks.size()];
        Enumeration enumeration = this._bookmarks.keys();
        n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public static XMLBookmarks of(Document document) {
        XMLBookmarks xMLBookmarks;
        if (_allBookmarks == null) {
            _allBookmarks = new Hashtable();
            xMLBookmarks = null;
        } else {
            xMLBookmarks = (XMLBookmarks)_allBookmarks.get(document);
        }
        if (xMLBookmarks == null) {
            xMLBookmarks = new XMLBookmarks(document);
            _allBookmarks.put(document, xMLBookmarks);
        }
        return xMLBookmarks;
    }

    public synchronized void set(String string, Element element) {
        Element element2 = element;
        synchronized (element2) {
            if (element.getOwnerDocument() != this._document) {
                throw new IllegalArgumentException("Element and bookmarks do not belong to same document.");
            }
            this._bookmarks.put(string, element);
        }
    }

    public synchronized void setUnique(String string, Element element) throws Exception {
        Element element2 = element;
        synchronized (element2) {
            if (element.getOwnerDocument() != this._document) {
                throw new IllegalArgumentException("Element and bookmarks do not belong to same document.");
            }
            Object v = this._bookmarks.get(string);
            if (v != null && v != element) {
                throw new Exception("Identifier not unique in this document.");
            }
            this._bookmarks.put(string, element);
        }
    }
}

