/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.dom;

import org.openxml.dom.DOMExceptionImpl;
import org.openxml.dom.DocumentImpl;
import org.openxml.dom.NodeImpl;
import org.w3c.dom.Entity;
import org.w3c.dom.Node;

public class EntityImpl
extends NodeImpl
implements Entity {
    protected String _notation;
    protected String _systemId;
    protected String _publicId;
    private short _state;
    private String _internalValue;
    public static final short STATE_DECLARED = 0;
    public static final short STATE_PARSING = 1;
    public static final short STATE_PARSED = 2;
    public static final short STATE_NOT_FOUND = 3;

    private EntityImpl(DocumentImpl documentImpl, String string) {
        super(documentImpl, string, null, true);
    }

    public EntityImpl(DocumentImpl documentImpl, String string, String string2) {
        super(documentImpl, string, null, true);
        if (string2 == null) {
            throw new NullPointerException("Argument 'internalValue' cannot be null.");
        }
        this._systemId = null;
        this._publicId = null;
        this._notation = null;
        this._state = 0;
        this._internalValue = string2;
    }

    public EntityImpl(DocumentImpl documentImpl, String string, String string2, String string3) {
        super(documentImpl, string, null, true);
        if (string2 == null) {
            throw new NullPointerException("Argument 'systemId' cannot be null.");
        }
        this._systemId = string2;
        this._publicId = string3;
        this._notation = null;
        this._state = 0;
    }

    public EntityImpl(DocumentImpl documentImpl, String string, String string2, String string3, String string4) {
        super(documentImpl, string, null, true);
        if (string4 == null) {
            throw new NullPointerException("Argument 'notation' cannot be null.");
        }
        this._systemId = string2;
        this._publicId = string3;
        this._notation = string4;
        this._notation = string4;
    }

    public final Object clone() {
        EntityImpl entityImpl = new EntityImpl(this._ownerDocument, this.getNodeName());
        this.cloneInto(entityImpl, true);
        return entityImpl;
    }

    protected synchronized void cloneInto(NodeImpl nodeImpl, boolean bl) {
        super.cloneInto(nodeImpl, bl);
        ((EntityImpl)nodeImpl)._systemId = this._systemId;
        ((EntityImpl)nodeImpl)._publicId = this._publicId;
        ((EntityImpl)nodeImpl)._notation = this._notation;
        ((EntityImpl)nodeImpl)._internalValue = this._internalValue;
        ((EntityImpl)nodeImpl)._state = this._state;
    }

    public final Node cloneNode(boolean bl) {
        EntityImpl entityImpl = new EntityImpl(this._ownerDocument, this.getNodeName());
        this.cloneInto(entityImpl, bl);
        return entityImpl;
    }

    public synchronized boolean equals(Object object) {
        if (super.equals(object)) {
            EntityImpl entityImpl = (EntityImpl)object;
            if (this.isInternal()) {
                return entityImpl.isInternal() && this.getInternal().equals(entityImpl.getInternal());
            }
            return (this._publicId == null && entityImpl._publicId == null || this._publicId != null && this._publicId.equals(entityImpl._publicId)) && (this._systemId == null && entityImpl._systemId == null || this._systemId != null && this._systemId.equals(entityImpl._systemId)) && (this._notation == null && entityImpl._notation == null || this._notation != null && this._notation.equals(entityImpl._notation));
        }
        return false;
    }

    public final String getInternal() {
        return this._internalValue;
    }

    public short getNodeType() {
        return 6;
    }

    public String getNotationName() {
        return this._notation;
    }

    public String getPublicId() {
        return this._publicId;
    }

    public short getState() {
        return this._state;
    }

    public String getSystemId() {
        return this._systemId;
    }

    public boolean isInternal() {
        return this._internalValue != null;
    }

    public boolean isUnparsed() {
        return this._notation != null;
    }

    public final void setNodeValue(String string) {
        throw new DOMExceptionImpl(6, "This node type does not support values.");
    }

    public void setState(short s) {
        if (this._state == 0 && s == 1 || this._state == 3 && s == 0) {
            this._state = s;
        } else if (!(this._state != 0 && this._state != 1 || s != 2 && s != 3)) {
            this._state = s;
        } else {
            throw new IllegalStateException("Cannot switch from state " + this._state + " to state " + s + ".");
        }
    }

    protected final boolean supportsChildern() {
        return true;
    }

    public String toString() {
        String string = this.getNodeName();
        if (string.length() > 32) {
            string = String.valueOf(string.substring(0, 32)) + "..";
        }
        if (this.isInternal()) {
            String string2 = this.getInternal();
            if (string2.length() > 64) {
                string2 = String.valueOf(string2.substring(0, 64)) + "..";
            }
            string = String.valueOf(string) + "] [" + string2;
        } else {
            if (this.getSystemId() != null) {
                string = String.valueOf(string) + "] SYSTEM [" + this.getSystemId();
            }
            if (this.getPublicId() != null) {
                string = String.valueOf(string) + "] PUBLIC [" + this.getPublicId();
            }
            if (this.getNotationName() != null) {
                string = String.valueOf(string) + "] NDECL [" + this.getNotationName();
            }
        }
        return "Entity decl: [" + string + "]";
    }
}

