/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.openxml.io.HTMLDTD;
import org.openxml.io.Printer;
import org.openxml.io.XMLStreamWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLParagraphElement;
import org.w3c.dom.html.HTMLPreElement;
import org.w3c.dom.html.HTMLScriptElement;
import org.w3c.dom.html.HTMLStyleElement;

public final class HTMLPrinter
extends Printer {
    public HTMLPrinter(OutputStream outputStream, int n) throws IOException {
        this(new XMLStreamWriter(outputStream), n, 70, 4);
    }

    public HTMLPrinter(OutputStream outputStream, String string, int n) throws IOException, UnsupportedEncodingException {
        this(new XMLStreamWriter(outputStream, string), n, 70, 4);
    }

    public HTMLPrinter(Writer writer) throws IOException {
        this(writer, 0, 70, 4);
    }

    public HTMLPrinter(Writer writer, int n) throws IOException {
        this(writer, n, 70, 4);
    }

    public HTMLPrinter(Writer writer, int n, int n2, int n3) throws IOException {
        super(writer, n, n2, n3);
    }

    protected String getCharacterRef(char c) {
        return HTMLDTD.fromChar(c);
    }

    public void print(Document document) throws IOException {
        this.printNode(document);
        this.flush();
    }

    public void print(DocumentFragment documentFragment) throws IOException {
        this.printNode(documentFragment);
        this.flush();
    }

    public void print(Element element) throws IOException {
        this.printNode(element);
        this.flush();
    }

    protected void printDocument(Node node, StringBuffer stringBuffer) throws IOException {
        if (node instanceof HTMLDocument) {
            this.printPart("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\"");
            this.breakLine();
            this.printPart("  \"http://www.w3.org/TR/REC-html40/strict.dtd\">");
            this.breakLine();
        }
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            this.printNode(node2);
            node2 = node2.getNextSibling();
        }
        this.breakLine();
    }

    protected void printElement(Element element, StringBuffer stringBuffer) throws IOException {
        stringBuffer.append("<").append(element.getTagName());
        this.printPart(stringBuffer);
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n);
            this.printSpace();
            stringBuffer.setLength(0);
            stringBuffer.append(attr.getName());
            if (attr.getValue() != null) {
                stringBuffer.append("=\"");
                stringBuffer.append(this.encode(attr.getValue(), true));
                stringBuffer.append('\"');
            }
            this.printPart(stringBuffer);
            ++n;
        }
        this.printPart(">");
        if (element.hasChildNodes() || HTMLDTD.supportsChildren(element)) {
            this.indent();
            int n2 = this.getMode();
            if (element instanceof HTMLPreElement || element instanceof HTMLScriptElement || element instanceof HTMLStyleElement) {
                this.setMode(this.getMode() & 0xFFFFFFFD);
            }
            Node node = element.getFirstChild();
            boolean bl = false;
            while (node != null) {
                if (this.mode(1) && node instanceof Element && node.hasChildNodes()) {
                    this.breakLine();
                    bl = true;
                }
                this.printNode(node);
                node = node.getNextSibling();
            }
            stringBuffer.setLength(0);
            this.setMode(n2);
            this.unindent();
            if (bl) {
                this.breakLine();
            }
            stringBuffer.append("</").append(element.getTagName()).append('>');
            this.printPart(stringBuffer);
            if (this.mode(1)) {
                this.breakLine();
            }
        } else if (this.mode(1) && element instanceof HTMLParagraphElement) {
            this.breakLine();
        }
    }
}

