/*****************************************************************************

    Copyright (C) 1994,1997 Ivan A. Curtis.  All rights reserved.

This code must not be re-distributed without these copyright notices intact.

*******************************************************************************
*******************************************************************************

Filename:	~icurtis/src/mx/basic.h

Description:	

Update History:   (most recent first)
   I. Curtis   9-Apr-97 12:02 -- Updated
   I. Curtis  22-Mar-94 23:11 -- Created.

******************************************************************************/
#ifndef __MX_BASIC
#define __MX_BASIC

#ifndef NULL
#define NULL 0
#endif

#include "X11/Xlib.h"
#include "X11/Xutil.h"

#define MXItemFlag_Left       0
#define MXItemFlag_Center     1
#define MXItemFlag_Right      2
#define MXItemMask_Align      3
#define MXItemFlag_Disabled   4
#define MXItemFlag_Hilite     8
#define MXItemFlag_Underlined 16
#define MXItemFlag_Overlined  32
#define MXItemFlag_Boxed      48

#define mx_min(a, b) ((a) < (b) ? (a) : (b))
#define mx_max(a, b) ((a) > (b) ? (a) : (b))

/***************************************
 * A menu item has text and attributes *
 ***************************************/
typedef struct _mx_menu_item {
  int flag;			/* alignment, disabled etc. */
  char *text;			/* the text string */
  int length;			/* length of the text string */
} mx_menu_item;

/****************************************
 * An appearance structure contains the *
 * parameters which define the overall  *
 * appearance of menus etc.             *
 ****************************************/
typedef struct _mx_appearance {
  int win_border;		/* size of window border (pixels) */
  int item_border;		/* amount of room around each item (pixels) */
  XFontStruct *font;		/* a font structure */
  int em, ascent, descent;	/* font characteristics (pixels) */
  GC gcf, gcd;			/* flipping and drawing GCs */
  Pixmap stipple;		/* a bitmap for stipple patterns */
  Pixmap button;		/* a bitmap for buttons */
  int button_width,
    button_height;
  int (*expose_fun)(XEvent *event);  /* function to call for exposure */
} mx_appearance;

typedef struct _mx_panel {
  mx_appearance *app;		/* the appearance structure */
  int width, height;		/* dimension of each panel item (pixels) */
  int n_items;			/* number of items in panel */
  mx_menu_item *item;		/* pointer to an array of items */
  int first_item, last_item;	/* sub-range of items used */
} mx_panel;


extern Window mx_window_open(Display *display, int screen, char *title,
			     int WindowXSize, int WindowYSize,
			     int WindowBorder);

extern mx_panel *mx_panel_create(Display *display, mx_appearance *app,
				 int n_items, mx_menu_item *mi);

extern mx_appearance *mx_appearance_create(Display *display, int screen,
					   Window window,
					   char *font_name,
					   int win_border, int item_border,
					   int pix_width, int pix_height,
					   char *pix_bits,
					   int (*expose_fun)(XEvent *event));

extern void mx_items_draw(Display *display, Window window, mx_appearance *app,
			  mx_menu_item *item, int start_item, int max_items,
			  int width, int height,
			  int tlx, int tly);

extern void mx_adjust_xy(Display *display, int width, int height,
			 int *x, int *y);

extern Window mx_transient_window_open(Display *display, int screen,
				       int border, int xpos, int ypos,
				       int xsize, int ysize);

extern void mx_window_close(Display *display, Window window);

#endif
/*****************************************************************************

    Copyright (C) 1994,1997 Ivan A. Curtis.  All rights reserved.

This code must not be re-distributed without these copyright notices intact.

*******************************************************************************
*******************************************************************************

Filename:	~icurtis/src/mx/alert.h

Description:	

Update History:   (most recent first)
   I. Curtis   9-Apr-97 12:02 -- Updated
   I. Curtis  22-Mar-94 23:11 -- Created.

******************************************************************************/

typedef struct _mx_alert {
  Window window;
  mx_appearance *app;		/* the appearance structure */
  int width, height;		/* dimension of each panel (pixels) */
  int inside;			/* flag indicating focus */
  int momentary;
  int start_item;
  int max_items;		/* number of items in alert */
  mx_menu_item *item;		/* pointer to array of items */
} mx_alert;

extern int mx_popup_alert(Display *display, int screen, mx_panel *main_panel,
			  mx_panel *resp_panel,
			  int *x, int *y);

extern int mx_alert_event(Display *display, int screen, XEvent *event,
			  mx_alert *alert, int *done, int *x, int *y);
/*****************************************************************************

    Copyright (C) 1994,1997 Ivan A. Curtis.  All rights reserved.

This code must not be re-distributed without these copyright notices intact.

*******************************************************************************
*******************************************************************************

Filename:	~icurtis/src/mx/menu.h

Description:	

Update History:   (most recent first)
   I. Curtis   9-Apr-97 12:02 -- Updated
   I. Curtis  22-Mar-94 23:11 -- Created.

******************************************************************************/

typedef struct _mx_menu {
  Window window;
  mx_appearance *app;		/* the appearance structure */
  int width, height;		/* dimension of each menu item (pixels) */
  int item_width;		/* width of largest menu item (pixels) */
  int n_items;			/* number of items in menu */
  mx_menu_item *item;		/* pointer to array of items */
  int start_item, max_items;	/* sub-range of items used */
  int inside;			/* flag indicating focus */
  int momentary;
  int choice;			/* -1 for no choice */
  int cur_x, cur_y;		/* cursor position in window */
  int cur_w, cur_h;		/* cursor size */
} mx_menu;

extern mx_menu *mx_menu_create(Display *display, mx_appearance *app,
			       int n_items, mx_menu_item *mi);

extern int mx_popup_menu(Display *display, int screen, mx_panel *panel,
			 int *x, int *y, int momentary);

extern int mx_menu_event(Display *display, int screen, XEvent *event,
			 mx_menu *menu, int *done, int *x, int *y);
/*****************************************************************************

    Copyright (C) 1994,1997 Ivan A. Curtis.  All rights reserved.

This code must not be re-distributed without these copyright notices intact.

*******************************************************************************
*******************************************************************************

Filename:	~icurtis/src/mx/request.h

Description:	

Update History:   (most recent first)
   I. Curtis   9-Apr-97 12:02 -- Updated
   I. Curtis  22-Mar-94 23:11 -- Created.

******************************************************************************/

typedef struct _mx_request {
  Window window;
  mx_appearance *app;		/* the appearance structure */
  int width, height;		/* dimension of request window (pixels) */
  int inside;			/* flag indicating focus */
  int cur_x, cur_y;		/* cursor position in window */
  int cur_w, cur_h;		/* cursor size */
  int cp;			/* cusor position in text */
  char *text;			/* request string */
  int length;			/* length of request string */
  int max_len;			/* maximum length of request string */
} mx_request;

extern int mx_popup_request(Display *display, int screen, mx_panel *panel,
			    int *x, int *y, char *text, int max_len);
/*****************************************************************************

    Copyright (C) 1994,1997 Ivan A. Curtis.  All rights reserved.

This code must not be re-distributed without these copyright notices intact.

*******************************************************************************
*******************************************************************************

Filename:	~icurtis/src/mx/select.h

Description:	

Update History:   (most recent first)
   I. Curtis   9-Apr-97 12:02 -- Updated
   I. Curtis  22-Mar-94 23:11 -- Created.

******************************************************************************/

typedef struct _mx_scroll {
  Window window;
  mx_appearance *app;		/* the appearance structure */
  int width, height;		/* dimension of scroll window (pixels) */
  mx_menu *menu;		/* pointer to menu being scrolled */
  int inside;			/* flag indicating focus */
  int cur_x, cur_y;		/* cursor position in window */
  int cur_w, cur_h;		/* cursor size */
  int min_item, max_item;
} mx_scroll;

extern int mx_popup_select(Display *display, int screen, mx_panel *panel,
			   int *x, int *y, int max_items);
/*****************************************************************************

    Copyright (C) 1994,1997 Ivan A. Curtis.  All rights reserved.

This code must not be re-distributed without these copyright notices intact.

*******************************************************************************
*******************************************************************************

Filename:	~icurtis/src/mx/buttons.h

Description:	

Update History:   (most recent first)
   I. Curtis   9-Apr-97 12:02 -- Updated
   I. Curtis  22-Mar-94 23:11 -- Created.

******************************************************************************/

typedef struct _mx_button {
  Window window;
  mx_appearance *app;		/* the appearance structure */
  int width, height;		/* dimension of each button (pixels) */
  int n_items;			/* number of buttons */
  mx_menu_item *item;		/* pointer to array of items */
  int first_item, last_item;	/* sub-range of items used */
  int inside;			/* flag indicating focus */
  int cur_x, cur_y;		/* cursor position in window */
  unsigned int value;		/* bitmap of button states */
} mx_button;

extern mx_popup_button(Display *display, int screen, mx_panel *panel,
		       unsigned int value, int *x, int *y);
/*****************************************************************************

    Copyright (C) 1994,1997 Ivan A. Curtis.  All rights reserved.

This code must not be re-distributed without these copyright notices intact.

*******************************************************************************
*******************************************************************************

Filename:	~icurtis/src/mx/filesel.c

Description:	

Update History:   (most recent first)
   I. Curtis   9-Apr-97 12:02 -- Updated
   I. Curtis  22-Mar-94 23:11 -- Created.

******************************************************************************/

extern char *mx_popup_filesel(Display *display, int screen,
			      mx_appearance *app,
			      int *x, int *y, int allP);
