/*****************************************************************************

	    Confidential and Proprietary to Ivan A. Curtis

      Copyright (C) 1997, Ivan A. Curtis.  All rights reserved.

This precautionary copyright notice against inadvertent publication is
neither an acknowledgement of publication, nor a waiver of confidentiality.

*******************************************************************************
*******************************************************************************

Filename:	~icurtis/develop/pilot/xcopilot-v0.3/mx/test_filesel.c

Description:	

Update History:   (most recent first)
     I. Curtis  20-Mar-97 19:31 -- Created.

******************************************************************************/
#include <stdio.h>
#include "libmx.h"

#define MAIN_N_ITEMS 4
mx_menu_item main_items[] = {
  {MXItemFlag_Center, "File", 0},
  {MXItemFlag_Left, "Open..", 0},
  {MXItemFlag_Left | MXItemFlag_Disabled, "                   ", 0},
  {MXItemFlag_Left, "Quit", 0},
};


/*****************************************************************************
 *                                                                           *
 * 				 Main                                        *
 *                                                                           *
 *****************************************************************************/

int main(int argc, char *argv[])
{
  Display *display;		          /* X Display */
  int screen;			          /* X screen */
  XEvent event;
  Window main_window, menu_window;          /* X Menu window */
  int done, choice;
  mx_appearance *app, *app2;
  mx_panel *panel_main, *panel_select;
  int main_width, main_height, main_x, main_y;
  char text[20];
  int x, y;

  strcpy(text, "Hello, World");
				/*** Open display ***/
  display = XOpenDisplay("");
  screen = DefaultScreen(display);

  main_window = mx_window_open(display, screen, "Menu", 140, 300, 2);

  XSelectInput(display, main_window, StructureNotifyMask |
	       OwnerGrabButtonMask | ButtonPressMask | ButtonReleaseMask);

  /* -adobe-helvetica-bold-r-normal--18-* */
  app = mx_appearance_create(display, screen, main_window,
			     "lucidasans-12", 2, 2, 0, 0, NULL, NULL);
  panel_main = mx_panel_create(display, app, MAIN_N_ITEMS, main_items);
  panel_select = NULL;

  done = 0;
  while (!done) {
    XNextEvent(display, &event);
    switch(event.type) {
    case ConfigureNotify:
      printf("config event (%d %d %d %d)\n",
	     event.xconfigure.x, event.xconfigure.y,
	     event.xconfigure.width, event.xconfigure.height);
      main_x = event.xconfigure.x;
      main_y = event.xconfigure.y;
      main_width = event.xconfigure.width;
      main_height = event.xconfigure.height;
      break;
    case Expose:
      break;
    case ButtonPress:
      x = event.xbutton.x_root;
      y = event.xbutton.y_root;
      if (event.xbutton.button == 1) {
	char *selection;
	choice = mx_popup_menu(display, screen, panel_main, &x, &y, True);
	switch (choice) {
	case 1:
	  selection = mx_popup_filesel(display, screen, app, &x, &y, 1);
	  if (selection) {
	    printf("Choice was \"%s\"\n", selection);
	  } else {
	    printf("problem\n");
	  }
	  break;
	case 3:
	  done = 1;
	  break;
	default:
	  break;
	}
      } else if (event.xbutton.button == 2) {
	;
      } else if (event.xbutton.button == 3) {
      }
      break;
    case ButtonRelease:
      break;
    default:
      break;
    }
  }
  mx_window_close(display, main_window);
  return 0;
}
