let using_pthread =
  ref (try Thread.kill (Thread.create (fun () -> ()) ()); false
       with Invalid_argument _ -> true)

external init : unit->unit = "mlgtkthr_init"
let _ = init ()

let mutex = let m = Mutex.create () in Mutex.lock m; m
  (* Ensures exclusive access to GTK functions. *)
let switch = Mutex.create ()
  (* Used for handshaking between [gtk_main] and other threads. *)

(* POSIX threads : use a unix pipe and GTK's input callbacks. *)

external native_main : unit -> unit = "mlgtkthr_main"
external set_sync_callback : Unix.file_descr -> (unit->unit) -> unit 
                           = "mlgtkthr_set_sync_callback"

let setup_pthread () =
  let sync_rd, sync_wr = ThreadUnix.pipe () in    
  let sync_callback () =
    if ThreadUnix.read sync_rd " " 0 1 <> 1 then failwith "sync read";
    Mutex.unlock mutex;
    (* Wait until peer has taken the mutex. *)
    Mutex.lock switch;
    Mutex.lock mutex;
    Mutex.unlock switch
  in
  set_sync_callback sync_rd sync_callback;
  let lock () =
    Mutex.lock switch;
    if ThreadUnix.write sync_wr "\n" 0 1 <> 1 then failwith "sync write";
    Mutex.lock mutex;
    Mutex.unlock switch
  in
  let unlock () = Mutex.unlock mutex in
  native_main, lock, unlock

(* Emulated threads : use short timeouts (ugly) *)

external native_main_iteration : bool -> int = "mlgtkthr_main_iteration"

let setup_emu () =
  Unix.set_nonblock Unix.stdin; (* ocaml-2.02 problem *)
  ignore (Gtk.timeout_add 100 (fun _ -> true));
  let pending_request = ref false in (* Protected by [switch]. *)
  let main () =
    while true do
      ignore(native_main_iteration true);
      if !pending_request then begin
  	Mutex.unlock mutex;
  	(* Wait until peer has taken the mutex. *)
  	Mutex.lock switch;
  	Mutex.lock mutex;
  	Mutex.unlock switch
      end else Thread.delay 0.001 (* Yield. *)
    done
  in
  let lock () =
    Mutex.lock switch;
    pending_request := true; (* Request a handshake. *)
    Mutex.lock mutex;
    pending_request := false;
    Mutex.unlock switch
  in
  let unlock () = Mutex.unlock mutex in
  main, lock, unlock

let main, lock, unlock = if !using_pthread then setup_pthread ()
                                           else setup_emu ()

(* let _ = Thread.create main ()
   Can't do that because gtk_main does not seem to expect user inputs
   (registered with [gtk_input_add_full]) if no windows have been built.
*)
