/*
 *                     The OCaml-gtk interface
 *
 * Copyright (c) 1997, 1998   David Monniaux & Pascal Cuoq
 *
 *
 * This file is distributed under the conditions described in
 * the file LICENSE.  
 */

/* $Id: mlglib_stub.c,v 1.11 1999/06/21 12:23:51 sven Exp $ */

#include <glib.h>
#include <caml/mlvalues.h>
#include <caml/callback.h>

value mlg_list_free(value list)
{
  g_list_free((GList*) list);
  return Val_unit;
}

value mlg_list_free_1(value list)
{
  g_list_free_1((GList*) list);
  return Val_unit;
}

value mlg_list_insert(value list, value item, value index)
{
  return (value)
    g_list_insert((GList*) list, (gpointer) item, Int_val(index));
}

value mlg_list_nth(value list, value item)
{
  return (value) g_list_nth((GList*) list, Int_val(item));
}

value mlg_list_length(value list)
{
  return Val_int(g_list_length((GList*) list));
}

value mlg_slist_free(value list)
{
  g_slist_free((GSList*) list);
  return Val_unit;
}

value mlg_slist_free_1(value list)
{
  g_slist_free_1((GSList*) list);
  return Val_unit;
}

value mlg_slist_insert(value list, value item, value index)
{
  return (value)
    g_slist_insert((GSList*) list, (gpointer) item, Int_val(index));
}

value mlg_slist_nth(value list, value item)
{
  return (value) g_slist_nth((GSList*) list, Int_val(item));
}

value mlg_slist_length(value list)
{
  return Val_int(g_slist_length((GSList*) list));
}

void mlglib_callback_exec(value x, value closure)
{
  callback(closure, x);
}

value mlg_list_foreach(value list, value func)
{
  g_list_foreach((GList*) list, 
    (GFunc) mlglib_callback_exec, (gpointer) func);
  return Val_unit;
}

value mlg_slist_foreach(value list, value func)
{
  g_slist_foreach((GSList*) list,
    (GFunc) mlglib_callback_exec, (gpointer) func);
  return Val_unit;
}

value mlg_zero(value dummy)
{
  return 0;
}
