#include <rtl.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/mman.h>



int *start;
int address = 0xA0000;
size_t length = 1000;

int init_module(void )
{
	int i;

	int fd = open("/dev/mem", O_RDWR);
	if (fd < 0) {
		rtl_printf("failed to open /dev/mem\n");
		return -1;
	}
	start = (int *) mmap(0, length, PROT_READ|PROT_WRITE, MAP_SHARED, fd,
			address);
	if (start == (int *) -1) {
		rtl_printf("failed to map /dev/mem\n");
		return -1;
	}
	for (i = 0; i < 100; i++) {
		rtl_printf ("%d ", start[i]);
	}
	rtl_printf ("\n");
		
	return 0;
}


void cleanup_module(void )
{
       munmap(start, length);
}

#ifndef MODULE

int main(void)
{
	if (init_module() == 0) {
		cleanup_module();
	}
	return 0;
}
#endif
