/*
 * RT-Linux debug routines
 *
 * Written by Michael Barabanov
 * Copyright (C) VJY Associates LLC, 1998-1999
 * Released under the terms of the GPL
 *
 * Idea from include/linux/sunrpc/debug.h
 * Copyright (C) 1996, Olaf Kirch <okir@monad.swb.de>
 *
 */

#ifndef __RTL_DEBUG__
#define __RTL_DEBUG__

extern unsigned int rtl_debug;

#define do_times(x) { static count=x; while (count-- > 0) {
#define end_do_times() }}

#define do_every(x) do { static count=x; if (!(count++ % x))
#define end_do_every } while (0)

#ifdef __KERNEL__

#define dprintk(args...)	dfprintk(FACILITY, ## args)

#undef ifdebug
#ifdef CONFIG_RTL_DEBUG			

extern void rtl_setdebug (unsigned int state);
extern unsigned int rtl_getdebug (void);

#define RTLDBG_HEARTBEAT	0x0001
#define RTLDBG_TIMER		0x0002
#define RTLDBG_TIME		0x0004
#define RTLDBG_OVERRUN		0x0008
#define RTLDBG_SCHED		0x0010
#define RTLDBG_ALL		0x7fff

# define ifdebug(fac)		if (rtl_debug & RTLDBG_##fac)
# define dfprintk(fac, args...)	do { ifdebug(fac) rtl_printf(## args); } while(0)
#else

#define rtl_setdebug(x)
#define rtl_getdebug() 0

# define dfprintk(fac, args...)	do ; while (0)
# define ifdebug(fac)		if (0)
#endif


#endif /* __KERNEL__ */


#endif /* __RTL_DEBUG__ */

