#!/bin/sh
#
# config.sh ---	Script to configure the Portable Forth Environment
#		automatically.
#
# Please execute `config.sh' like this:
#
#	sh ./config.sh [system]
#
#   If your `sh' doesn't know shell functions, then use ksh or one of
#   the many free shells ash, bash, pd-ksh or zsh.
#   On OS/2 I used bash112 (ms_shell doesn't work) but I got errors as
#   long as this script contained carriage returns. After changing all
#   CF/LF to LF only (recode ibmpc:latin1) everything was fine.
#
#   If no system is specified:
#
#	the script tries to detect what kind of system you use,
#	using the command uname (available on most unices) or
#	by testing certain system specific environment variables.
#	The system name must be a single word that can be used in
#	a `#define name' statement.
#
#   Available system names are: (* detected automatically)
#
#	* Linux
#	  FreeBSD	FreeBSD(*) or BSD386 or NetBSD
#	* EMX		DOS or OS/2 with gcc and EMX DOS extender
#	  WATCOM	Watcom C, set TARGET in the Makefile!
#	* AIX1		AIX version 1.2 on PS/2
#	* AIX3		AIX version 3.x on RS/6000
#	* HPUX		HP-UX 8.x or later on HP9000/4x or HP9000/[78]x
#	* NeXTstep	for Intel
#	* SunOS		SunOS 4.3, maybe also Solaris 2.4 but not 2.3
#	* ULTRIX	DEC ULTRIX RISC 4.3 on DecStation
#	* OSF1		DEC OSF1 2.x on DEC Alpha workstation
#
# Check if the two files generated by this script:
#
#	Makefile
#	config.h
#
# describe your system adequately. Maybe Makefile contains more compilation
# hints and user settable options (at least a PREFIX indicating where pfe
# should look for help files). Please read Makefile before making.
#
# Then build pfe by typing `make'. Good luck.
#
# (duz 15Mar95)
#


#until [ $# -eq 0 ]
#do
#  case $1 in
#    PREFIX=*|--prefix=*)
#	PREFIX=`echo $1 | cut -d'=' -f2` ;;
#    *)
#	break ;;
#  esac
#  shift
#done

case $# in
  0)
    if [ -n "$OS2_SHELL" ]; then system=EMX
    elif uname > /dev/null; then system=`uname`; unamea=`uname -a`
    elif [ -n "$OSTYPE" ];  then system=$OSTYPE
    else
      echo "What kind of system do you use? "
      read system
    fi ;;
  1)
    system=$1 ;;
  *)
    echo "usage: sh ./config.sh [ --prefix=directory ] [system]" >&2
    exit ;;
esac


case $system in
  AIX)
    # two versions are supported
    case `uname -m` in
      i?86) system=AIX1 ;;
      *)    system=AIX3 ;;
    esac
    ;;
  HP-UX)
    case `uname -m` in
      9000/[34]*) system=HPUX68K  ;;
      9000/[78]*) system=HPUXRISC ;;
    esac
    ;;
  NeXTStep)
    # Convert uname output for NeXTStep on Next hardware.
    system=NeXTstep ;;
esac
echo "Configuring pfe for $system..." >&2


#
# Create `Makefile':
#

for part in header basics options rules depend
do
  if [ -f config/$system/$part.mk ]
  then
    cat config/$system/$part.mk
  else
    cat config/default/$part.mk
  fi
done > Makefile


#
# Create `config.h'
#

if [ -f config/$system/config.h ]
then
  cp -p config/$system/config.h .
else
  . ./guesscfg.sh $system
fi

echo "Configuration created." >&2
exit 0
