__id__ = """
$Id: //depot/LLNLDistribution/Numerical/Lib/Matrix.py#8 $
"""[1:-1]
import string
__version__ = int(__id__[string.index(__id__, '#')+1:-1])

from UserArray import UserArray, asarray
from Numeric import matrixmultiply

class Matrix(UserArray):
    def __mul__(self, other):
	return self._rc(matrixmultiply(self.array, asarray(other)))

    def __rmul__(self, other):
	return self._rc(matrixmultiply(asarray(other), self.array))

    def __pow__(self, other):
	raise TypeError, "x**y not implemented for matrices x"

    def __rpow__(self, other):
	raise TypeError, "x**y not implemented for matrices y"


if __name__ == '__main__':
	from Numeric import *
	m = Matrix( [[1,2,3],[11,12,13],[21,22,23]])
	print m*m
	print m.array*m.array
	print transpose(m)
