"""Test of gendoc.

Chapter 1

  Ok, this is chapter one. First, we start off by testing *emphasized words*,
  **bold words** and some quotations: 'We can bury her, burn her or dump her'.

  Hopefully, it understands bullet lists as well:

  - Bullet one
  - Bullet two
  - Bullet three

  Bullet lists comes in different shapes:

  * Bullets as stars (of course you won't see these variations if
    you are looking at this in your favourite Grail browser).

  * Here's another star bullet (bullet lists must use consistent
    bullets).

  The last variation on this theme is:

  o Oooh, this is beautiful
  o ooops, do yoo loko thos?

Chapter 2

  Now, here is something spectacular. Gendoc supports nested lists,
  and numbered lists!

  * This is an outer bullet

    o This is an inner bullet

      - This is an even innier bullet

      - This is as inny as above bullet

    o This is not as inny as above, but certainly innier than the first

  * Back to the least inny bullet

  1. Yes, that's right. I am number one.

  2. I'm not far behind

    a. I should be the first in the second numbered bullet

    b. I should be the last in the second numbered bullet

  3. Last but not least (actually most, 3 > 2 > 1)

Chapter 3

  Another new feature is definition lists:

  rows -- is a string like "20%,*,20%" stating the number and widths of
          rows defined for the frames. Widths for each row can be expressed in
          integer (absolute pixels), percentage (of overall browser window or
          containing frame), or asterisk(*) to indicate an auto-resized remainder
          width.

  cols -- is a string of the same format as above except applied to column
          widths. There should not be both a rows and cols attribute in the same
          Frameset tag.

  frame_warning -- optional flag is available to indicate if a <NOFRAMES>
          statement should be included with the Frameset to alert browsers without
          frame support. Default is 1 (yes).

  onLoad -- is a string of script code, which is executed when the frameset
             is loaded

  onUnload -- is a string of script code, which is executed when the frameset
               is unloaded

  Definitions

     word -- definition
     word -- definition

     o Nested lists needs a blank line inbetween.

       - This is an even innier bullet

       - This is as inny as above bullet

     o This is not as inny as above, but certainly innier than the first

     o Unnested lists don't need blanks (but can have)
     o Look, no blank line!

Links

  Links are written within brackets: [Python home page].
  To be interpreted as a link, you must put a link definition
  at the end of the doc string.

Example:

  $ pythondoc -f HTML4 pythondoc.test

.. [Python home page] http://www.python.org
"""

class Test:
    """A short docstring"""
    pass

class Test2(Test):
    """A subclass!

    Test2 inherits from [Test].

    .. [Test] Test
    """
    pass

