#
# $Header: /usr/local/cvsroot/pythondoc/xref/xref.py,v 1.2 1999/05/01 01:11:48 daniel Exp $
#
# Copyright (C) Daniel Larsson
# All Rights Reserved.
#
# See copyright notice in the file 'LICENSE.TXT', which should have accompanied
# this distribution.

"""Cross reference registration module.
"""

__author__ = "Daniel Larsson"
__version__ = "$Revision: 1.2 $"[11:-2]

import os

# Will contain all available cross reference extensions
xref_extensions = {}

def main(path):
    files = reduce(lambda c, dir: c+os.listdir(dir), path, [])
    modules = filter(lambda file: file[-7:] == 'Xref.py', files)

    for module in modules:
	py_module = module[:-3]
	try:
	    exec "import %s" % py_module
	except ImportError:
	    import sys
	    sys.stderr.write('Warning: Failed to import %s (%s: %s)\n' %
			     (py_module, sys.exc_type, sys.exc_value))


def register_xref(clazz, xref_scheme):
    """Register cross reference extension class.

    Arguments:

      clazz -- Class to handle cross references.
      
      xref_scheme -- The cross reference scheme the class handles.
    """
    if xref_extensions.has_key(xref_scheme):
	import sys
	sys.stderr.write("Cross reference scheme %s already" \
			 "has a registered class: %s.%s" \
			 % (xref_scheme, clazz.__module__, clazz.__name__))
	sys.stderr.write("Skipping class %s.%s" % \
			 (clazz.__module__, clazz.__name__))
	return

    xref_extensions[xref_scheme] = clazz

#
# $Log: xref.py,v $
# Revision 1.2  1999/05/01 01:11:48  daniel
# Removed Windows style line endings.
#
# 
# *****************  Version 2  *****************
# User: Daniel       Date: 98-08-06   Time: 16:45
# Updated in $/Pythondoc/xref
# Added header and footer.
# 
