/*								-*- C++ -*-
 * $Id: DEV_screendc.cpp,v 1.1 1996-09-25 11:30:54+02 mho Exp $
 *
 * Purpose: device context to draw on the root window
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1996, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1996, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "DEV_screendc.h"
#endif

#define  Uses_XLib
#define  Uses_wxWindow
#define  Uses_wxScreenDC
#include "wx.h"

IMPLEMENT_DYNAMIC_CLASS(wxScreenDC, wxWindowDC);
 
// static data
Bool   wxScreenDC::m_drawOnTop      = FALSE;
Window wxScreenDC::m_overlayWindow  = 0;
int    wxScreenDC::m_overlayWindowX = 0;
int    wxScreenDC::m_overlayWindowY = 0;

//-----------------------------------------------------------------------------
// wxScreenDC
//-----------------------------------------------------------------------------

wxScreenDC::wxScreenDC(void) : wxWindowDC()
{
    __type = wxTYPE_DC_SCREEN;

    device = wxDEVICE_SCREEN;

    if (m_overlayWindow) {
	// use overlay window, if one is created
	SetDeviceOrigin(-m_overlayWindowX, -m_overlayWindowY);
	Initialize(wxAPP_DISPLAY, wxAPP_SCREEN, m_overlayWindow);
    } else if (m_drawOnTop) {
	// draw on top if already drawing on top
	Initialize(wxAPP_DISPLAY, wxAPP_SCREEN, wxAPP_ROOT);
	XGCValues values;
	values.subwindow_mode = IncludeInferiors;
	XChangeGC(wxAPP_DISPLAY, PenGC(), GCSubwindowMode, &values);
	XChangeGC(wxAPP_DISPLAY, BrushGC(), GCSubwindowMode, &values);
	XChangeGC(wxAPP_DISPLAY, TextGC(), GCSubwindowMode, &values);
	XChangeGC(wxAPP_DISPLAY, BgGC(), GCSubwindowMode, &values);
    } else {
	// simple root background drawing
	Initialize(wxAPP_DISPLAY, wxAPP_SCREEN, wxAPP_ROOT);
    }
}

wxScreenDC::~wxScreenDC(void)
{
}

//-----------------------------------------------------------------------------
// Drawing on top (otherwise wxScreenDC will draw on root window)
//-----------------------------------------------------------------------------

/*!
 * StartDrawingOnTop() is used to draw on top of windows. Note, that you
 * have to care yourself for undoing your drawings.
 * /r TRUE, if call succeeded
 */
Bool wxScreenDC::StartDrawingOnTop(void)
{
    if (m_overlayWindow || m_drawOnTop)
	return FALSE;

    // draw on top, i.e. set "IncludeInferiors" for GC subwindow mode
    m_drawOnTop = TRUE;
    XGCValues values;
    values.subwindow_mode = IncludeInferiors;
    // change GCs
    XChangeGC(wxAPP_DISPLAY, PenGC(), GCSubwindowMode, &values);
    XChangeGC(wxAPP_DISPLAY, BrushGC(), GCSubwindowMode, &values);
    XChangeGC(wxAPP_DISPLAY, TextGC(), GCSubwindowMode, &values);
    XChangeGC(wxAPP_DISPLAY, BgGC(), GCSubwindowMode, &values);
    // grab server
    // XGrabServer(wxAPP_DISPLAY); // SOMETIMES LONG DELAY ???

    return TRUE;
}

/*!
 * StartDrawingOnTop(window) is used to draw on top of windows in the area
 * occupied by the given window.
 * /p window: gives the size of the area to draw on
 * /r         TRUE, if call succeeded.
 */
Bool wxScreenDC::StartDrawingOnTop(wxWindow *window)
{
    wxRectangle rect;
    window->GetPosition(&rect.x, &rect.y);
    window->ClientToScreen(&rect.x, &rect.y);
    window->GetSize(&rect.width, &rect.height);
    return StartDrawingOnTop(&rect);
}

/*!
 * StartDrawingOnTop(rect) is needed to draw on top of windows in the area
 * occupied by the ginven rectangle.
 * /p rect: gives the size of the area to draw on
 * /r       TRUE, if call succeeded.
 */
Bool wxScreenDC::StartDrawingOnTop(wxRectangle *rect)
{
    if (m_overlayWindow || m_drawOnTop)
	return FALSE;

    int x = 0;
    int y = 0;
    int width, height;
    wxDisplaySize(&width, &height);

    if (rect) {
	x = rect->x; y = rect->y;
	width = rect->width; height = rect->height;
    }
    m_overlayWindowX = x;
    m_overlayWindowY = y;

    // skip window bny windowmanager
    XSetWindowAttributes attributes;
    attributes.override_redirect = True;
    // create window
    m_overlayWindow = XCreateWindow(wxAPP_DISPLAY, wxAPP_ROOT,
				    x, y, width, height, 0,
				    wxDisplayDepth(), InputOutput,
				    DefaultVisual(wxAPP_DISPLAY, 0), 
				    CWOverrideRedirect, &attributes);
    if (m_overlayWindow) {
	XMapWindow(wxAPP_DISPLAY, m_overlayWindow);
	DrawArea()   = m_overlayWindow;
	DrawWindow() = m_overlayWindow;
	SetDeviceOrigin(-m_overlayWindowX, -m_overlayWindowY);
	return TRUE;
    }
    return FALSE;
}

/*!
 * EndDrawingOnTop finishes any other call to /l StartDrawingOnTop.
 * /r TRUE, if call succeeded.
 */
Bool wxScreenDC::EndDrawingOnTop(void)
{
    Bool success = FALSE;

    if (m_overlayWindow) {
	// don't draw on window anymore and reset drawable to root
	XDestroyWindow(wxAPP_DISPLAY, m_overlayWindow);
	m_overlayWindow = 0;
	DrawArea()      = wxAPP_ROOT;
	DrawWindow()    = wxAPP_ROOT;
	SetDeviceOrigin(0, 0);
	success = TRUE;
    } else if (m_drawOnTop) {
	// ungrab server
	// XUngrabServer(wxAPP_DISPLAY); // SOMETIMES LONG DELAY ???
	// don't draw on top, i.e. set "ClipByChildren" for GC subwindow mode
	m_drawOnTop = FALSE;
	XGCValues values;
	values.subwindow_mode = ClipByChildren;
	// change GCs
	XChangeGC(wxAPP_DISPLAY, PenGC(), GCSubwindowMode, &values);
	XChangeGC(wxAPP_DISPLAY, BrushGC(), GCSubwindowMode, &values);
	XChangeGC(wxAPP_DISPLAY, TextGC(), GCSubwindowMode, &values);
	XChangeGC(wxAPP_DISPLAY, BgGC(), GCSubwindowMode, &values);
	success = TRUE;
    }
    return success;
}

//-----------------------------------------------------------------------------
// ask, if a part of the DC is exposed
//-----------------------------------------------------------------------------

int wxScreenDC::IsExposed(float WXUNUSED(x), float WXUNUSED(y))
{
    return wxEXPOSED_FULL; // has always to be redrawn completely
}

int wxScreenDC::IsExposed(float WXUNUSED(x), float WXUNUSED(y),
			  float WXUNUSED(w), float WXUNUSED(h))
{
    return wxEXPOSED_FULL; // has always to be redrawn completely
}
