/*								-*- C++ -*-
 * $Id: WIN_gauge.cpp,v 1.2 1997-01-15 14:59:02+01 mho Exp $
 *
 * Purpose: gauge panel item
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "WIN_gauge.h"
#endif

#define  Uses_XtIntrinsic
#define  Uses_wxGauge
#include "wx.h"
#define  Uses_EnforcerWidget
#define  Uses_GaugeWidget
#include <widgets.h>

//-----------------------------------------------------------------------------
// create and destroy gauge
//-----------------------------------------------------------------------------

IMPLEMENT_DYNAMIC_CLASS(wxGauge, wxItem)

wxGauge::wxGauge(void) : wxItem()
{
    __type = wxTYPE_GAUGE;

    range = value = 0;
}

wxGauge::wxGauge(wxPanel *panel, Const char *label, int _range,
		 int x, int y, int width, int height, long style, Constdata char *name)
{
    __type = wxTYPE_GAUGE;

    range = value = 0;

    Create(panel, label, _range, x, y, width, height, style, name);
}

Bool wxGauge::Create(wxPanel *panel, Const char *label, int _range,
		     int x, int y, int width, int height, long style,
		     Constdata char *name)
{
    ChainToPanel(panel, style, name);

    range     = _range;

    // create frame
    FWidget() = XtVaCreateManagedWidget
	(name, xfwfEnforcerWidgetClass, GetParentWidget(parent),
	 XtNlabel,       label,
	 XtNalignment,   (((label_position==wxVERTICAL) || (style&wxVERTICAL)) ?
			  XfwfTop : XfwfLeft),
	 XtNbackground,  bg.GetPixel(&cmap),
	 XtNforeground,  label_fg.GetPixel(&cmap),
	 XtNfont,        label_font.GetInternalFont(),
	 XtNtraversalOn, FALSE,
	 XtNframeType,   XfwfSunken,
	 XtNframeWidth,  2,
	 NULL);
    // create the slider widget
    HWidget() = XtVaCreateManagedWidget
	(name, xfwfGaugeWidgetClass, FWidget(),
	 XtNbackground,    bg.GetPixel(&cmap),
	 XtNforeground,    fg.GetPixel(&cmap),
	 XtNthumbColor,    bg.GetPixel(&cmap),
	 XtNminsize,	   0,
	 XtNframeType,     XfwfRaised,
	 XtNframeWidth,    0,
	 XtNhighlightThickness, 0,
	 NULL);
    SetValue(0);
    // set data declared in wxItem
    // panel positioning
    if (width < 0)
	width = (style & wxVERTICAL)  ? wxGAUGE_HEIGHT : wxGAUGE_WIDTH;
    if (height < 0)
	height = (style & wxVERTICAL) ? wxGAUGE_WIDTH  : wxGAUGE_HEIGHT;

    panel->PositionItem(this, x, y, width, height);
    AddEventHandlers();

    return TRUE;
}

//-----------------------------------------------------------------------------
// methods to access internal data
//-----------------------------------------------------------------------------

void wxGauge::SetButtonColour(wxColour &col)
{
    if (HWidget())
	XtVaSetValues(HWidget(), XtNthumbColor, col.GetPixel(&cmap), NULL);
    wxItem::SetButtonColour(col);
}

void wxGauge::SetRange(int new_range)
{
    if (0 <= new_range) {
	range = new_range;
	SetValue(value);
    }
}

void wxGauge::SetValue(int new_value)
{
    if (0 <= new_value && new_value <= range) {
	value = new_value;
	if (style & wxVERTICAL) {
	    XfwfMoveThumb  (HWidget(), 0.0, 1.0                      );
	    XfwfResizeThumb(HWidget(), 1.0, float(value)/float(range));
	} else {
	    XfwfMoveThumb  (HWidget(), 0.0,                       0.0);
	    XfwfResizeThumb(HWidget(), float(value)/float(range), 1.0);
	}
    }
}
