/*
 * File:	GLCanvas.cpp
 * Purpose:	wxWindows interface for OpenGL using the GLX extension
 * Author:	Wolfram Gloger (adapted from J. Smart's Windows version)
 * Created:	1995
 * Updated:	Jul 1996, for wx-Xt 1.65 (WG)
 */

#define	Uses_XtIntrinsic
#define Uses_GLCanvas
#include "wx.h"

#define Uses_ShellWidget
#include "widgets.h"

/*
 * GLCanvas implementation
 */

GLCanvas::GLCanvas(wxWindow *parent, int x, int y, int w, int h,
				   long style, char *name, int *attrib_list):
wxCanvas(parent, x, y, w, h, style, name)
{
	Display *display = XtDisplay(HWidget());
	XVisualInfo *vi, vi_templ;
	int val, n;

	glx_cx = 0;
	is_rgba = FALSE;
	// Check for the presence of the GLX extension
	if(!glXQueryExtension(display, NULL, NULL)) {
		wxDebugMsg("GLCanvas: GLX extension is missing\n");
		return;
	}

	if(attrib_list) {
		// Get an appropriate visual
		vi = glXChooseVisual(display, DefaultScreen(display), attrib_list);
		if(!vi) return;

		// Here we should make sure that vi is the same visual as the
		// one used by the xwindow drawable in wxCanvas.  However,
		// there is currently no mechanism for this in wx_canvs.cpp.
	} else {
#if 0
		// By default, we use the visual of xwindow
		Window xwindow = XtWindow(HWidget());
		XWindowAttributes xwa;

		XGetWindowAttributes(display, xwindow, &xwa);
		vi_templ.visualid = XVisualIDFromVisual(xwa.visual);
#else
		// Use visual of the parent shell widget.
		Widget w = wxFindFrame(this)->FWidget();
		Visual *v;

		//cerr << "w = " << (void *)w << endl;
		if(!XtIsShell(w)) {
			wxError("canvas parent is no shell widget", "GLCanvas");
			return;
		}
		XtVaGetValues(w, XtNvisual, &v, NULL);
		if(!v)
			v = XDefaultVisualOfScreen(XtScreen(w));
		//cerr << "visual = " << hex << (void *)v << endl;
		vi_templ.visualid = XVisualIDFromVisual(v);
#endif
		//cerr << "vid = " << hex << (int)vi_templ.visualid << endl;
		vi = XGetVisualInfo(display, VisualIDMask, &vi_templ, &n);
		if(!vi) {
			wxError("can't get visual info", "GLCanvas");
			return;
		}
		glXGetConfig(display, vi, GLX_USE_GL, &val);
		if(!val) {
			wxError("canvas widget has unsuitable visual", "GLCanvas");
			return;
		}
		// Basically, this is it.  It should be possible to use vi
		// in glXCreateContext() below.	 But this fails with Mesa.
		// I notified the Mesa author about it; there may be a fix.
#ifdef OLD_MESA
		// Construct an attribute list matching the visual
		int a_list[32];
		n = 0;
		if(vi->c_class==TrueColor || vi->c_class==DirectColor) { // RGBA visual
			a_list[n++] = GLX_RGBA;
			a_list[n++] = GLX_RED_SIZE;
			a_list[n++] = bitcount(vi->red_mask);
			a_list[n++] = GLX_GREEN_SIZE;
			a_list[n++] = bitcount(vi->green_mask);
			a_list[n++] = GLX_BLUE_SIZE;
			a_list[n++] = bitcount(vi->blue_mask);
			glXGetConfig(display, vi, GLX_ALPHA_SIZE, &val);
			a_list[n++] = GLX_ALPHA_SIZE;
			a_list[n++] = val;
		} else { // Color index visual
			glXGetConfig(display, vi, GLX_BUFFER_SIZE, &val);
			a_list[n++] = GLX_BUFFER_SIZE;
			a_list[n++] = val;
		}
		a_list[n] = None;
		XFree(vi);
		vi = glXChooseVisual(display, DefaultScreen(display), a_list);
		if(!vi) return;
#endif /* OLD_MESA */
	}

	// Create the GLX context and make it current
	glx_cx = glXCreateContext(display, vi, 0, GL_TRUE);
#ifndef OLD_MESA
	XFree(vi);
#endif
	GLSetCurrent();
}

GLCanvas::~GLCanvas(void)
{
	if(glx_cx)
		glXDestroyContext(XtDisplay(HWidget()), glx_cx);
}

void
GLCanvas::GLSwapBuffers(void)
{
	if(glx_cx && XtWindow(HWidget()))
		glXSwapBuffers(XtDisplay(HWidget()), XtWindow(HWidget()));
}

int
GLCanvas::GLSetCurrent(void)
{
	Window win = XtWindow(HWidget());

	if(!glx_cx || !win)
		return -1;
	if(!glXMakeCurrent(XtDisplay(HWidget()), win, glx_cx)) {
		wxError("can't set current context", "GLCanvas");
		return -2;
 	}
	glGetBooleanv(GL_RGBA_MODE, &is_rgba);
	return 0;
}

void
GLCanvas::GLSetColour(const char *col)
{
	wxColour *the_colour = wxTheColourDatabase->FindColour(col);
	if(the_colour) {
		if(IsRGBA()) {
			glColor3ub(the_colour->Red(),
					   the_colour->Green(),
					   the_colour->Blue());
		} else {
			GLint pix = (GLint)the_colour->GetPixel(&cmap);
			// GetPixel() can't fail in wx-Xt (maybe returns black).
			//cerr << "col=" << col << " pix=" << (int)pix << endl;
			glIndexi(pix);
		}
	}
}

/*
 * Local variables:
 * tab-width:4
 * End:
 */
