/*								-*- C++ -*-
 * $Id: WIN_textwindow.cpp,v 1.3 1999/09/23 21:57:01 wg Exp $
 *
 * Purpose: text window panel item
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "WIN_textwindow.h"
#endif

#define  Uses_XtIntrinsic
#define  Uses_wxTextWindow
#include "wx.h"
//#define  Uses_AsciiTextWidgetPrivate
#define  Uses_AsciiTextWidget
#define  Uses_EnforcerWidget
#define  Uses_ScrollWinWidget
#include <widgets.h>

#include <unistd.h>		// for access
#include <sys/types.h>		// for stat/fileinfo
#include <sys/stat.h>

//-----------------------------------------------------------------------------
// create and destroy textWindow
//-----------------------------------------------------------------------------

IMPLEMENT_DYNAMIC_CLASS(wxTextWindow, wxMultiText)

wxTextWindow::wxTextWindow(void) : wxMultiText(), streambuf()
{
    __type = wxTYPE_TEXT_WINDOW;

    if( allocate() )
	setp(base(),ebuf());
 
    modified = FALSE;
}

wxTextWindow::wxTextWindow(wxWindow *panel, int x, int y, int width, int height,
			   long style, Constdata char *name) : wxMultiText(), streambuf()
{
    __type = wxTYPE_TEXT_WINDOW;

    if( allocate() )
	setp(base(),ebuf());

    modified = FALSE;
    Create(panel, x, y, width, height, style, name);
}

Bool wxTextWindow::Create(wxWindow *panel, int x, int y, int width, int height,
			 long style, Constdata char *name)
{
    if (!panel || !panel->IsKindOf(CLASSINFO(wxPanel)))
	wxFatalError("parent has to be a wxFrame, wxPanel, or any subtype", "wxTextWindow");
    ChainToPanel((wxPanel*)panel, style, name);

    XFontStruct *xfont = font.GetInternalFont();

    // create frame
    FWidget() = XtVaCreateManagedWidget
	(name, xfwfEnforcerWidgetClass, GetParentWidget(parent),
	 XtNalignment,          XfwfTop,
	 XtNbackground,         bg.GetPixel(&cmap),
	 XtNforeground,         label_fg.GetPixel(&cmap),
	 XtNfont,               label_font.GetInternalFont(),
	 XtNhighlightThickness, 2,
	 XtNlabelOffset,        2,
	 XtNtraversalKeys,      XfwfTraverseKeyTab,
	 NULL);
    // create viewport
    PWidget() = XtVaCreateManagedWidget
	(name, xfwfScrolledWindowWidgetClass, FWidget(),
	 XtNbackground,      bg.GetPixel(&cmap),
	 XtNscrollingPolicy, XfwfUserScrolling,
	 XtNtraversalKeys,   XfwfTraverseKeyTab,
	 XtNvIncrement,      xfont->ascent+xfont->descent,
	 XtNhIncrement,      xfont->max_bounds.width,
	 NULL);
    // create textWindow widget
    HWidget() = XtVaCreateManagedWidget
	(name, asciiTextWidgetClass, PWidget(),
	 XtNbackground,       bg.GetPixel(&cmap),
	 XtNforeground,       fg.GetPixel(&cmap),
	 XtNfont,             font.GetInternalFont(),
	 XtNtopMargin,        2,
	 XtNrightMargin,      2,
	 XtNborderWidth,      0,
	 XtNtype,             XawAsciiFile,
// 	 XtNscrollVertical,   XawtextScrollNever,
// 	 XtNscrollHorizontal, XawtextScrollNever,
// 	 XtNresize,           XawtextResizeNever,
	 XtNeditType,         (style & wxREADONLY ? XawtextRead : XawtextEdit),
	 NULL);
    // callback
    XtAddCallback(XawTextGetSource(HWidget()), XtNcallback,
		  wxTextWindow::EventCallback, (XtPointer)this);

    ((wxPanel*)panel)->PositionItem(this, x, y,
				    (width  > -1 ? width  : wxTEXT_WINDOW_WIDTH),
				    (height > -1 ? height : wxTEXT_WINDOW_HEIGHT));
    AddEventHandlers();
    return TRUE;
}

//-----------------------------------------------------------------------------
// methods to allow program to modify text
//-----------------------------------------------------------------------------

void wxTextWindow::Clear(void)
{
    XtVaSetValues(HWidget(), XtNstring, NULL, NULL);
}

/* Martin Sperl
char *wxTextWindow::GetContents(void)
{
    char *value=NULL;
    
    off_t i;
    int c;
    // get a temporary filename
    char *filename=::wxGetTempFileName("TextOut");
    // write the file to a temprary file
    SaveFile(filename);
    // get size of file
    struct stat fileinfo;
    stat(filename,&fileinfo);
    off_t size=fileinfo.st_size;
    // allocate buffer (more just in case...);
    value= new char[size+10];
    // clean buffer
    for (i=0;i<size+10;i++) { value[i]=0; }
    // read from file
    FILE* file=fopen(filename,"r");
    // cannot open file
    if (file==NULL) { delete value; return NULL; }
    // fill buffer
    for (i=0;i<size;i++)
	{
	    c=(char)fgetc(file);
	    if (c!=EOF)
		{
		    // write to Buffer
		    value[i]=(char)c;
		}
	    else
		{
		    // write End of text
		    value[i]=0;
		    break;
		}
	}
    // write End of text again, just to be sure...
    value[i]=0;
    // close file
    fclose(file);
    // delete file
    ::wxRemoveFile(filename);
    // delete filename
    delete filename;
    // return buffer
    return value;
}
*/

/* this might fail since XawTextSourceRead() is allowed to return
 * only part of text. Also, GetContents should allocate a fresh
 * piece of memory -- grano@cs.helsinki.fi 5/98

char *wxTextWindow::GetContents(void)
{
    static XawTextBlock text_block;
    Widget src = XawTextGetSource(HWidget());
    text_block.firstPos = 0;
    text_block.format = FMT8BIT;
    int maxlength = 1000000;
    XawTextSourceRead(src, 0, &text_block, maxlength);
    return text_block.ptr;
} */

char *wxTextWindow::GetContents(void)
{
    char* result, *resp;
    Widget src = XawTextGetSource(HWidget());
    XawTextBlock text_block;
    XawTextPosition start, middle;
    int length, really;

    length = LastPosition();
    result = new char[length+1];

    text_block.firstPos = 0;
    text_block.format = FMT8BIT;

    // XawTextSourceRead is allowed to read less than 'length' bytes!
    for (resp = result, start = 0;
	 length > 0;
	 length -= really, resp += really, start = middle) {
	middle = XawTextSourceRead(src, start, &text_block, length);
	really = middle-start;
	if(really <= 0)
	    break;
	memcpy(resp, text_block.ptr, really);
    }

    *resp = '\0';
    return result;
}

long wxTextWindow::GetInsertionPoint(void)
{
    return long(XawTextGetInsertionPoint(HWidget()));
/*
    XawTextPosition beg, end;
    XawTextGetSelectionPos(HWidget(),&beg,&end);
    cout<<"beg = "<<beg<<" ; end = "<<end<<endl;
*/
}

long wxTextWindow::GetLastPosition(void)
{
    return LastPosition();
}

int wxTextWindow::GetLineLength(long lineNo)
{
    Widget src = XawTextGetSource(HWidget());
    XawTextPosition start, end;
 
    start = XawTextSourceScan(src, 0, XawstEOL, XawsdRight, lineNo, True);
    end = XawTextSourceScan(src, start, XawstEOL, XawsdRight, 1, False);
 
    return end-start; // not including final '\n'
}

int wxTextWindow::GetLineText(long lineNo, char* buf)
{
    Widget src = XawTextGetSource(HWidget());
    XawTextBlock text_block;
    XawTextPosition start, middle, end;

    start = XawTextSourceScan(src, 0, XawstEOL, XawsdRight, lineNo, True);
    end = XawTextSourceScan(src, start, XawstEOL, XawsdRight, 1, False);

    int total_length = end-start;  	// not including final '\n'
    int length, really;
    text_block.firstPos = 0;
    text_block.format = FMT8BIT;

    // cout << "READING (" << length << ") bytes" << endl;
    // XawTextSourceRead is allowed to read less than 'length' bytes!
    for (length = total_length;
	 length > 0;
	 length -= really, start = middle) {
	middle = XawTextSourceRead(src, start, &text_block, length);
	really = middle-start;
	// cout << "..got " << really << " bytes" << endl;
	if(really <= 0)
	    break;

	memcpy(buf, text_block.ptr, really);
	buf += really;

	// cout << "LOOPING for line " << lineNo << endl;
    }

    *buf = '\0';
    return total_length;
}

int wxTextWindow::GetNumberOfLines(void)
{
    int lines = 0;
    Widget src = XawTextGetSource(HWidget());
    XawTextPosition lastPos, pos = 0;

    for(;;) {
	lastPos = XawTextSourceScan(src, pos, XawstEOL, XawsdRight, 1, True);
	if (pos == lastPos)
		break;
	lines++;
	pos = lastPos;
    }
    return lines;
}

Bool wxTextWindow::LoadFile(char *file)
{
    Bool readable = FALSE, writable = FALSE;

    if (file) {
	readable = (Bool)(access(file, R_OK) == 0);
	writable = (Bool)(access(file, W_OK) == 0);
    }

    XtVaSetValues
	(HWidget(),
	 XtNeditType, (((style & wxREADONLY) || !writable) && readable) ? XawtextRead
									: XawtextEdit,
	 XtNstring,   (readable ? file : NULL),
	 NULL);
    modified = FALSE;

    // set scrollbars
    AdjustScrollbars();

    return readable;
}

void wxTextWindow::PositionToXY(long pos, long *x, long *y)
{
    int lines=-1;
    Widget src = XawTextGetSource(HWidget());
    XawTextPosition lastPos, curPos = -1;
 
    if (pos < 0) {
	*x = *y = 0;
	return;
    }

    for(;;) {
	lastPos = XawTextSourceScan(src,curPos+1,XawstEOL,XawsdRight,1,False);

	if (curPos == lastPos) {	// pos exceeds text size
		// cout << "EOF while curPos = " << curPos << endl;
		*x = 0;
		*y = lines;
		return;
	}

	lines++;

	if (lastPos >= pos) {		// curPos+1 == start of previous line
		*x = pos - (curPos+1);
		*y = lines;
		// cout<< "FOUND cur="<< curPos<< " last="<< lastPos<< endl;
		return;
	}

	curPos = lastPos;
    }
}

void wxTextWindow::Remove(long from, long to)
{
    XawTextBlock text_block;
    text_block.firstPos = 0;
    text_block.length = 0;
    text_block.ptr = NULL;
    text_block.format = FMT8BIT;
    XawTextReplace(HWidget(), from, to, &text_block);
}

void wxTextWindow::Replace(long from, long to, char *value)
{
    XawTextBlock text_block;
    text_block.firstPos = 0;
    text_block.length = strlen(value);
    text_block.ptr = value;
    text_block.format = FMT8BIT;
    XawTextReplace(HWidget(), from, to, &text_block);
}

Bool wxTextWindow::SaveFile(char *file)
{
    modified = FALSE;
    return Bool(XawAsciiSaveAsFile(XawTextGetSource(HWidget()), file));
}

void wxTextWindow::SetEditable(Bool editable)
{
    XtVaSetValues(HWidget(), XtNeditType, (editable? XawtextEdit : XawtextRead), NULL);
}

void wxTextWindow::SetInsertionPoint(long pos)
{
    XawTextSetInsertionPoint(HWidget(), XawTextPosition(pos));
}

void wxTextWindow::SetInsertionPointEnd(void)
{
    XEvent event;
    memset(&event, 0, sizeof(event));
    XtCallActionProc(HWidget(), "end-of-file", (XEvent*)&event, NULL, 0);
}

void wxTextWindow::SetSelection(long from, long to)
{
    XawTextSetSelection(HWidget(), XawTextPosition(from), XawTextPosition(to));
}

void wxTextWindow::ShowPosition(long pos)
{
    XtVaSetValues(HWidget(),
		  XtNdisplayPosition, XawTextPosition(pos),
		  NULL);
}

void wxTextWindow::WriteText(char *text)
{
    WriteText(text, strlen(text));
}

void wxTextWindow::WriteText(char *text, long len)
{
    // insert text
    XawTextPosition last = GetLastPosition();
    XawTextBlock text_block;
    text_block.firstPos = 0;
    text_block.length = len;
    text_block.ptr = text;
    text_block.format = FMT8BIT;
    XawTextReplace(HWidget(), last, last, &text_block);
    AdjustScrollbars();
}

long wxTextWindow::XYToPosition(long x, long y)
{
    Widget src = XawTextGetSource(HWidget());

    return XawTextSourceScan(src, 0, XawstEOL, XawsdRight, y, True) + x;
}

//-----------------------------------------------------------------------------
// overload streambuf methods
//-----------------------------------------------------------------------------

// Called when the buffer is full
int wxTextWindow::overflow(int WXUNUSED(i))
{
    WriteText(pbase(), pptr() - pbase());
    setp(pbase(), epptr());
    return EOF;
}

// Called when "endl" is output
int wxTextWindow::sync(void)
{
    WriteText(pbase(), pptr() - pbase());
    setp(pbase(), epptr());
    return 0;
}

// Should not be called by an "ostream". Used by an "istream"
int wxTextWindow::underflow(void)
{
    // cerr << "TxtwinbufT::underflow " << endl;
    return EOF;
}

wxTextWindow& wxTextWindow::operator<<(char *s)
{
    WriteText(s);
    return *this;
}

wxTextWindow& wxTextWindow::operator<<(float f)
{
    char buf[100];
    sprintf(buf, "%.2f", f);
    WriteText(buf);
    return *this;
}

wxTextWindow& wxTextWindow::operator<<(double d)
{
    char buf[100];
    sprintf(buf, "%.2f", d);
    WriteText(buf);
    return *this;
}

wxTextWindow& wxTextWindow::operator<<(int i)
{
    char buf[100];
    sprintf(buf, "%i", i);
    WriteText(buf);
    return *this;
}

wxTextWindow& wxTextWindow::operator<<(long i)
{
    char buf[100];
    sprintf(buf, "%ld", i);
    WriteText(buf);
    return *this;
}

wxTextWindow& wxTextWindow::operator<<(char c)
{
    char buf[2];
    buf[0] = c;
    buf[1] = 0;
    WriteText(buf);
    return *this;
}

//-----------------------------------------------------------------------------
// callback for textWindowWidgetClass
//-----------------------------------------------------------------------------

void wxTextWindow::EventCallback(Widget WXUNUSED(w),
				 XtPointer clientData, XtPointer WXUNUSED(ptr))
{
    ((wxTextWindow*)clientData)->modified = TRUE;
}
