/*								-*- C++ -*-
 * $Id: DEV_windowdc.h,v 1.4 1996-11-29 09:40:57+01 mho Exp $
 *
 * Purpose: device context to draw drawables
 *          (windows and pixmaps, even if pixmaps are covered by wxMemoryDC)
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef WindowDC_h
#define WindowDC_h

// wxWindowDC is applyable to ALL from wxWindow derived classes!
// wxCanvasDC and wxPanelDC are aliases for compatibility
#define wxCanvasDC wxWindowDC
#define wxPanelDC  wxWindowDC

#ifdef __GNUG__
#pragma interface
#endif

class wxBitmap;
class wxBrush;
class wxColour;
class wxColourMap;
class wxFont;
class wxIcon;
class wxList;
class wxPen;
class wxWindowDC_Xintern;

class wxWindowDC : public wxDC {
DECLARE_DYNAMIC_CLASS(wxWindowDC)
public:
    wxWindowDC(void);
    ~wxWindowDC(void);

    // virtual methods, declared in wxDC
    Bool  Blit(float xdest, float ydest, float w, float h, wxDC *src,
	       float xsrc, float ysrc, int rop=wxCOPY);
    Bool  CanGetTextExtent(void) { return TRUE; }
    Bool  CanDrawBitmap(void) { return TRUE; }
    void  Clear(void);
    void  CrossHair(float x, float y);
    void  DestroyClippingRegion(void);
    void  DrawArc(float x1, float y1, float x2, float y2, float xc, float yc);
    void  DrawBitmap8(unsigned char *data, int w, int h,
		      wxColourMap *cmap, float x, float y);
    void  DrawEllipse(float x, float y, float w, float h,
		      int startAngle=64*0, int sizeAngle=64*360);
    void  DrawIcon(wxBitmap *icon, float x, float y, Bool useMask=FALSE);
    void  DrawLine(float x1, float y1, float x2, float y2);
    void  DrawLines(int n, wxPoint pts[], float xoff=0, float yoff=0);
    void  DrawLines(int n, wxIntPoint pts[], int xoff=0, int yoff=0);
    void  DrawLines(wxList *pts, float xoff=0, float yoff=0);
    void  DrawPoint(float x, float y);
    void  DrawPoint(wxPoint &pt)  { DrawPoint(pt.x, pt.y); }
    void  DrawPolygon(int n, wxPoint pts[], float xoff=0, float yoff=0,
		      int fill=wxODDEVEN_RULE);
    void  DrawPolygon(wxList *pts, float xoff=0, float yoff=0,
		      int fill=wxODDEVEN_RULE);
    void  DrawRectangle(float x, float y, float w, float h);
    void  DrawRoundedRectangle(float x, float y, float w, float h,
			       float radius=20);
    void  DrawText(const char *text, float x, float y, Bool use16Bit=FALSE);
    void  FloodFill(float x, float y, wxColour *col,int style=wxFLOOD_SURFACE);
    float GetCharHeight(void);
    float GetCharWidth(void);
    void  GetClippingRegion(float *x, float *y, float *w, float *h);
    void  GetTextExtent(const char *s, float *w, float *h, float *descent = 0,
			float *ext_leading = 0,	wxFont *font=NULL,
			Bool use16bit=FALSE);
    void  IntDrawLine(int x1, int y1, int x2, int y2);
    void  IntDrawLines(int n, wxIntPoint pts[], int xoff=0, int yoff=0);
    void  SetBackground(wxBrush *brush);
    void  SetBrush(wxBrush *brush);
    void  SetClippingRegion(float x, float y, float w, float h);
    void  SetColourMap(wxColourMap *cmap);
    void  SetFont(wxFont *font);
    void  SetLogicalFunction(int fkt);
    void  SetPen(wxPen *pen);
    void  SetTextBackground(wxColour *col);
    void  SetTextForeground(wxColour *col);
    // ask, if a part of the DC is exposed
    int IsExposed(float x, float y);
    int IsExposed(float x, float y, float width, float height);
    // necessary, if drawing needs server grabbing (e.g. rubber-bands)
    void BeginDrawing(void);
    void EndDrawing(void);
    // get size of device context
    void GetSize(float *w, float *h);
    // methods unique to wxWindowDC
    void SetCanvasClipping(void);
    void GetClippingBox(float *x, float *y, float *w, float *h);
protected:
    // friends to allow access to X structures.
    friend class wxCanvas;
    friend class wxWindow;
    friend class wxPostScriptDC;
#ifdef Have_X_Types
    // initialize and destroy DC
    void  Initialize(Display* dpy, Screen* scn, Drawable drawable);
    void  Destroy(void);
    // I need to know when the origin changes
    void  ComputeScaleAndOrigin(void);
    // access to X implementation
    GC&		  PenGC(void);
    GC&		  BrushGC(void);
    GC&		  TextGC(void);
    GC&		  BgGC(void);
    Region&	  UserReg(void);
    Region&	  ExposeReg(void);
    Region&	  CurrentReg(void);
    Display*&	  Dpy(void);
    Screen*&	  Scn(void);
    Drawable&	  DrawArea(void);
    Window&	  DrawWindow(void);
    unsigned int& Width(void);
    unsigned int& Height(void);
    unsigned int& Depth(void);
    Colormap	  CMap(void);
#endif

    // X internal representation
    wxWindowDC_Xintern* X;
};

#endif // WindowDC_hh
