/*								-*- C++ -*-
 * $Id: MSC_timer.h,v 1.1 1996-09-25 11:06:37+02 mho Exp $
 *
 * Purpose: class to process time outs
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef Timer_h
#define Timer_h

#ifdef __GNUG__
#pragma interface
#endif

class wxTimer : public wxObject {
public:
    wxTimer(void);
    ~wxTimer(void);

    int   Interval(void) { return interval; };
    Bool  Start(int millisec = -1, Bool one_shot = FALSE);
    void  Stop(void);
    // called on timeout
    virtual void Notify(void) {}
private:
    #ifdef Have_Xt_Types
    static void EventCallback(wxTimer *, XtIntervalId *);
    #endif

    int           interval;
    unsigned long id;
    Bool          one_shot;
};

#endif // Timer_h
