/*								-*- C++ -*-
 * $Id: WIN_message.h,v 1.2 1999/05/07 16:16:46 wmglo Exp $
 *
 * Purpose: message panel item
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef Message_h
#define Message_h

#ifdef __GNUG__
#pragma interface
#endif

class wxBitmap;
class wxPanel;

class wxMessage: public wxItem {
DECLARE_DYNAMIC_CLASS(wxMessage)
public:
    wxMessage(void);

    wxMessage(wxPanel *panel, Const char *label, int x=-1, int y=-1,
	      long style=0, Constdata char *name=wxMessageNameStr);
    wxMessage(wxPanel *panel, Const char *label, int x, int y, int width,
	      int height, long style=0, Constdata char *name=wxMessageNameStr);

    wxMessage(wxPanel *panel, wxBitmap *bitmap, int x=-1, int y=-1,
	      long style=0, Constdata char *name=wxMessageNameStr);
    wxMessage(wxPanel *panel, wxBitmap *bitmap, int x, int y, int width,
	      int height, long style=0, Constdata char *name=wxMessageNameStr);
    wxMessage(wxPanel *panel, wxBitmap& bitmap, int x=-1, int y=-1,
	      long style=0, Constdata char *name=wxMessageNameStr);
    
    Bool Create(wxPanel *panel, Const char *label, int x=-1, int y=-1,
		int w=-1, int h=-1, long style=0,
		Constdata char *name=wxMessageNameStr);
    Bool Create(wxPanel *panel, wxBitmap *bitmap, int x=-1, int y=-1,
		int w=-1, int h=-1, long style=0,
		Constdata char *name=wxMessageNameStr);
    Bool Create(wxPanel *panel, wxBitmap& bitmap, int x=-1, int y=-1,
		int w=-1, int h=-1, long style=0,
		Constdata char *name=wxMessageNameStr);

    void AllowResize(Bool allow);
    void SetAlignment(long alignment);
    void SetLabel(Const char *message);
    void SetLabel(wxBitmap *bitmap);
    void SetLabel(wxBitmap& bitmap);
    void SetLabelFont(wxFont *new_font);
    Bool IsBitmap(void) { return isBitmap; }
protected:
    Bool isBitmap;
private:
    wxBitmap bmp;
};

#endif // Message_h
